/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd;

import com.espressif.idf.core.IDFProjectNature;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.launch.serial.core.IDFProjectLaunchDescriptor;
import com.espressif.idf.ui.EclipseUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.ILaunchDescriptorType;

public class IDFDebugLaunchDescriptorType
implements ILaunchDescriptorType {
    public static final String ID = "com.espressif.idf.debug.gdbjtag.openocd.descriptorType";
    private Map<ILaunchConfiguration, IDFProjectLaunchDescriptor> descriptors = new HashMap<ILaunchConfiguration, IDFProjectLaunchDescriptor>();

    public ILaunchDescriptor getDescriptor(Object launchObject) {
        if (!(launchObject instanceof ILaunchConfiguration)) {
            return null;
        }
        ILaunchConfiguration config = (ILaunchConfiguration)launchObject;
        try {
            IProject project;
            ILaunchConfigurationType type = config.getType();
            String identifier = type.getIdentifier();
            if (identifier.equals("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationType") && IDFProjectNature.hasNature((IProject)(project = this.getMappedProject(config).orElseGet(() -> (IProject)EclipseUtil.getDefaultIDFProject().orElseThrow())))) {
                IDFProjectLaunchDescriptor descriptor = this.descriptors.get(config);
                if (descriptor == null) {
                    descriptor = new IDFProjectLaunchDescriptor((ILaunchDescriptorType)this, project, (ILaunchConfiguration)launchObject);
                    this.descriptors.put(config, descriptor);
                }
                return descriptor;
            }
        }
        catch (CoreException ce) {
            Logger.log((Exception)((Object)ce));
        }
        return null;
    }

    private Optional<IProject> getMappedProject(ILaunchConfiguration config) {
        IResource[] resources = null;
        try {
            resources = config.getMappedResources();
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return resources == null ? Optional.empty() : Stream.of(resources).filter(Objects::nonNull).filter(resource -> resource.getType() == 4).map(IResource::getProject).findFirst();
    }
}

