/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.core.variables;

import com.cthing.cmakeed.core.utils.StringUtils;
import com.cthing.cmakeed.core.variables.CMakeVariable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public final class CMakeVariables {
    private static final String PROPERTIES_EXT_ID = "variables";
    private static final String ATT_NAME = "name";
    private static final String ATT_DESC = "desc";
    private static final String ATT_DEPRECATED = "deprecated";
    private static Map<String, CMakeVariable> variables;

    private CMakeVariables() {
    }

    private static void loadCommands() {
        IExtension[] extensions;
        variables = new LinkedHashMap<String, CMakeVariable>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.cthing.cmakeed.core", PROPERTIES_EXT_ID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.isValid()) {
                IConfigurationElement[] commandElts;
                IConfigurationElement[] iConfigurationElementArray = commandElts = extension.getConfigurationElements();
                int n3 = commandElts.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement commandElt = iConfigurationElementArray[n4];
                    String name = commandElt.getAttribute(ATT_NAME);
                    String desc = commandElt.getAttribute(ATT_DESC);
                    Boolean deprecated = Boolean.valueOf(commandElt.getAttribute(ATT_DEPRECATED));
                    CMakeVariable cmd = new CMakeVariable(name, desc, deprecated);
                    variables.put(name, cmd);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static CMakeVariable getCommand(String name) {
        if (variables == null) {
            CMakeVariables.loadCommands();
        }
        return StringUtils.isBlank(name) ? null : variables.get(name.toUpperCase());
    }

    public static Collection<CMakeVariable> getCommands() {
        if (variables == null) {
            CMakeVariables.loadCommands();
        }
        return variables.values();
    }
}

