/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.core.commands;

import com.cthing.cmakeed.core.commands.CMakeCommand;
import com.cthing.cmakeed.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public final class CMakeCommands {
    private static final String COMMANDS_EXT_ID = "commands";
    private static final String ATT_NAME = "name";
    private static final String ATT_DESC = "desc";
    private static final String ATT_DEPRECATED = "deprecated";
    private static final String ATT_VALUE = "value";
    private static Map<String, CMakeCommand> commands;
    private static List<CMakeCommand> commandsSorted;

    private CMakeCommands() {
    }

    private static void loadCommands() {
        IExtension[] extensions;
        commands = new HashMap<String, CMakeCommand>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.cthing.cmakeed.core", COMMANDS_EXT_ID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.isValid()) {
                IConfigurationElement[] commandElts;
                IConfigurationElement[] iConfigurationElementArray = commandElts = extension.getConfigurationElements();
                int n3 = commandElts.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement[] usageElts;
                    IConfigurationElement commandElt = iConfigurationElementArray[n4];
                    String name = commandElt.getAttribute(ATT_NAME);
                    String desc = commandElt.getAttribute(ATT_DESC);
                    Boolean deprecated = Boolean.valueOf(commandElt.getAttribute(ATT_DEPRECATED));
                    CMakeCommand cmd = commands.get(name);
                    if (cmd == null) {
                        cmd = new CMakeCommand(name, desc, deprecated);
                        commands.put(name, cmd);
                    }
                    IConfigurationElement[] iConfigurationElementArray2 = usageElts = commandElt.getChildren();
                    int n5 = usageElts.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement usageElt = iConfigurationElementArray2[n6];
                        cmd.addUsage(usageElt.getAttribute(ATT_VALUE));
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static CMakeCommand getCommand(String name) {
        if (commands == null) {
            CMakeCommands.loadCommands();
        }
        return StringUtils.isBlank(name) ? null : commands.get(name.toLowerCase());
    }

    public static Collection<CMakeCommand> getCommands() {
        if (commands == null) {
            CMakeCommands.loadCommands();
        }
        if (commandsSorted == null) {
            commandsSorted = new ArrayList<CMakeCommand>(commands.values());
            Collections.sort(commandsSorted, new Comparator<CMakeCommand>(){

                @Override
                public int compare(CMakeCommand c1, CMakeCommand c2) {
                    int byName = c1.getName().compareToIgnoreCase(c2.getName());
                    return byName != 0 ? byName : c1.getUsages()[0].compareToIgnoreCase(c2.getUsages()[0]);
                }
            });
        }
        return commandsSorted;
    }
}

