/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.core.server;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.sdk.config.core.SDKConfigCorePlugin;
import com.espressif.idf.sdk.config.core.server.CommandType;
import com.espressif.idf.sdk.config.core.server.IJsonConfigOutput;
import com.espressif.idf.sdk.config.core.server.IMessageHandlerListener;
import com.espressif.idf.sdk.config.core.server.IMessagesHandlerNotifier;
import com.espressif.idf.sdk.config.core.server.JsonConfigOutput;
import com.espressif.idf.sdk.config.core.server.JsonConfigServerRunnable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.console.MessageConsoleStream;
import org.json.simple.parser.ParseException;

public class JsonConfigServer
implements IMessagesHandlerNotifier {
    protected MessageConsoleStream console;
    private List<IMessageHandlerListener> listeners;
    private IProject project;
    private JsonConfigServerRunnable runnable;
    private JsonConfigOutput configOutput;
    private Process process;
    private IFile file;

    public JsonConfigServer(IProject project, IFile file) {
        this.project = project;
        this.listeners = new ArrayList<IMessageHandlerListener>();
        this.configOutput = new JsonConfigOutput();
        this.file = file;
    }

    @Override
    public void addListener(IMessageHandlerListener listener) {
        this.listeners.add(listener);
    }

    public void destroy() {
        if (this.runnable != null) {
            this.runnable.destory();
        }
    }

    public void execute(String command, CommandType type) {
        if (this.runnable != null) {
            this.runnable.executeCommand(command, type);
        }
    }

    @Override
    public void notifyHandler(String message, CommandType type) {
        for (IMessageHandlerListener listener : this.listeners) {
            listener.notifyRequestServed(message, type);
        }
    }

    @Override
    public void removeListener(IMessageHandlerListener listener) {
        this.listeners.remove(listener);
    }

    public void start() throws IOException {
        IPath workingDir = this.project.getLocation();
        Map idfEnvMap = new IDFEnvironmentVariables().getSystemEnvMap();
        idfEnvMap.put("PYTHONUNBUFFERED", "1");
        File idfPythonScriptFile = IDFUtil.getIDFPythonScriptFile();
        if (!idfPythonScriptFile.exists()) {
            throw new FileNotFoundException("File Not found:" + String.valueOf(idfPythonScriptFile));
        }
        String pythonPath = IDFUtil.getIDFPythonEnvPath();
        List<String> arguments = Collections.emptyList();
        try {
            arguments = new ArrayList<String>(Arrays.asList(pythonPath, idfPythonScriptFile.getAbsolutePath(), "-B", IDFUtil.getBuildDir((IProject)this.project), "-DSDKCONFIG=".concat(this.file.getName()), "confserver"));
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        Logger.log((String)arguments.toString());
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        if (workingDir != null) {
            processBuilder.directory(workingDir.toFile());
        }
        Map<String, String> environment = processBuilder.environment();
        environment.putAll(idfEnvMap);
        environment.put("IDF_CCACHE_ENABLE", "false");
        Logger.log((String)environment.toString());
        String idfPath = environment.get("PATH");
        String processPath = environment.get("Path");
        if (!StringUtil.isEmpty((String)idfPath) && !StringUtil.isEmpty((String)processPath)) {
            idfPath = idfPath.concat(";").concat(processPath);
            environment.put("PATH", idfPath);
            environment.remove("Path");
        }
        Logger.log((String)environment.toString());
        processBuilder.redirectErrorStream(true);
        String oldSdkconfigValue = "";
        try {
            oldSdkconfigValue = this.getCmakeCacheSdkconfigValue();
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        this.process = processBuilder.start();
        this.runnable = new JsonConfigServerRunnable(this.process, this, this.project, oldSdkconfigValue);
        Thread t = new Thread(this.runnable);
        t.start();
    }

    private String getCmakeCacheSdkconfigValue() throws CoreException {
        File cmakeCacheFile = new File(IDFUtil.getBuildDir((IProject)this.project).concat("/CMakeCache.txt"));
        if (cmakeCacheFile.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(cmakeCacheFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("SDKCONFIG:UNINITIALIZED=")) continue;
                        return line;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
        return "";
    }

    public IJsonConfigOutput getOutput(String response, boolean isUpdate) {
        try {
            this.configOutput.parse(response, isUpdate);
        }
        catch (ParseException e) {
            Logger.log((Plugin)SDKConfigCorePlugin.getPlugin(), (Exception)((Object)e));
        }
        return this.configOutput;
    }

    public IJsonConfigOutput getOutput() {
        return this.configOutput;
    }

    public void addConsole(MessageConsoleStream console) {
        this.console = console;
    }

    public boolean isAlive() {
        return this.runnable.isAlive(this.process);
    }
}

