/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.core;

import com.espressif.idf.core.util.SDKConfigUtil;
import com.espressif.idf.sdk.config.core.KConfigMenuItem;
import com.espressif.idf.sdk.config.core.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class KConfigMenuProcessor {
    private IProject project;

    public KConfigMenuProcessor(IProject project) {
        this.project = project;
    }

    public KConfigMenuItem reader() throws Exception {
        SDKConfigUtil sdkConfigUtil = new SDKConfigUtil();
        String menuConfigPath = sdkConfigUtil.getConfigMenuFilePath(this.project);
        if (!new File(menuConfigPath).exists()) {
            throw new Exception(MessageFormat.format(Messages.KconfMenuJsonNotFound, menuConfigPath));
        }
        JSONParser parser = new JSONParser();
        KConfigMenuItem root = new KConfigMenuItem(null);
        BufferedReader breader = null;
        try {
            try {
                breader = new BufferedReader(new FileReader(menuConfigPath));
                Object obj = parser.parse((Reader)breader);
                this.read(obj, root);
            }
            catch (IOException | ParseException e) {
                throw new Exception(e);
            }
        }
        finally {
            try {
                if (breader != null) {
                    breader.close();
                }
            }
            catch (IOException ex) {
                breader = null;
            }
        }
        return root;
    }

    protected void read(Object obj, KConfigMenuItem menuItem) {
        JSONArray jsonArray = (JSONArray)obj;
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            KConfigMenuItem childMenu = new KConfigMenuItem(menuItem);
            JSONObject jsonObject = (JSONObject)iterator.next();
            childMenu.setName((String)jsonObject.get((Object)"name"));
            childMenu.setId((String)jsonObject.get((Object)"id"));
            childMenu.setType((String)jsonObject.get((Object)"type"));
            childMenu.setHelp((String)jsonObject.get((Object)"help"));
            if (jsonObject.get((Object)"is_menuconfig") != null) {
                childMenu.setIsMenuConfig((Boolean)jsonObject.get((Object)"is_menuconfig"));
            }
            String title = (String)jsonObject.get((Object)"title");
            childMenu.setTitle(title);
            if (title != null) {
                menuItem.addChild(childMenu);
            }
            JSONArray children = (JSONArray)jsonObject.get((Object)"children");
            this.read(children, childMenu);
        }
    }
}

