/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.ui;

import com.espressif.idf.sdk.config.ui.Messages;
import com.espressif.idf.ui.EclipseUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;

public class OpenSdkConfigEditor
extends AbstractHandler {
    private static final String SDKCONFIG_FILE_NAME = "sdkconfig";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        IProject project = EclipseUtil.getSelectedProjectInExplorer();
        try {
            IFile sdkConfigFile = project.getFile(SDKCONFIG_FILE_NAME);
            if (sdkConfigFile.exists()) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)sdkConfigFile);
            } else {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.SDKConfigurationFileNotFound_Title, (String)Messages.SDKConfigFileNotFound_ErrorMessage);
            }
        }
        catch (CoreException e) {
            throw new ExecutionException("Error opening sdkconfig file", (Throwable)e);
        }
        return null;
    }
}

