/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tools;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.ESPToolChainManager;
import com.espressif.idf.ui.tools.ToolsJob;
import com.espressif.idf.ui.update.ExportIDFTools;
import com.espressif.idf.ui.update.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.MessageConsoleStream;

public class ToolsInstallationJob
extends ToolsJob {
    public ToolsInstallationJob(String pythonExecutablePath, String gitExecutablePath, String idfPath) {
        super(Messages.InstallToolsHandler_InstallingToolsMsg, pythonExecutablePath, gitExecutablePath);
        this.idfPath = idfPath;
        this.idfToolSet.setIdfLocation(idfPath);
        this.idfToolSet.setSystemGitExecutablePath(gitExecutablePath);
        this.idfToolSet.setSystemPythonExecutablePath(pythonExecutablePath);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.InstallToolsHandler_ItWilltakeTimeMsg, 5);
        monitor.worked(1);
        Logger.log((String)"");
        IStatus status = this.handleToolsInstall();
        if (status.getSeverity() == 4) {
            return status;
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.InstallToolsHandler_InstallingPythonMsg);
        status = this.handleToolsInstallPython(this.console);
        if (status.getSeverity() == 4) {
            return status;
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.InstallToolsHandler_ExportingPathsMsg);
        ExportIDFTools exportIDFTools = new ExportIDFTools();
        status = exportIDFTools.getToolsExportOutputFromGivenIdfPath(this.pythonExecutablePath, this.gitExecutablePath, this.console, this.errorConsoleStream, this.idfPath);
        if (status.getSeverity() == 4) {
            return status;
        }
        Logger.log((String)status.getMessage());
        this.processExportCmdOutput(status.getMessage());
        monitor.worked(1);
        monitor.setTaskName(Messages.InstallToolsHandler_AutoConfigureToolchain);
        ESPToolChainManager espToolChainManager = new ESPToolChainManager();
        String pathToLookForToolChains = (String)this.idfToolSet.getEnvVars().get("PATH");
        String idfPath = (String)this.idfToolSet.getEnvVars().get("IDF_PATH");
        try {
            List espToolChains = espToolChainManager.getStdToolChains(Arrays.asList(pathToLookForToolChains.split(File.pathSeparator)), idfPath);
            this.idfToolSet.setEspStdToolChains(espToolChains);
            List cMakeToolChainFiles = espToolChainManager.getCmakeToolChains(idfPath);
            this.idfToolSet.setEspCmakeToolChainFiles(cMakeToolChainFiles);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            this.logToConsole("Error Getting Toolchains", this.errorConsoleStream);
            return IDFCorePlugin.errorStatus((String)"Error Getting Toolchains", null);
        }
        monitor.setTaskName("Loading Available Targets in IDF");
        status = this.loadTargetsAvailableFromIdfInCurrentToolSet();
        if (status.getSeverity() == 4) {
            return status;
        }
        this.idfToolSet.setLaunchTargets(this.extractTargets(status.getMessage()));
        monitor.worked(1);
        monitor.setTaskName(Messages.InstallToolsHandler_InstallingWebscoketMsg);
        this.handleWebSocketClientInstall();
        monitor.worked(1);
        this.console.println(Messages.InstallToolsHandler_ToolsCompleted);
        this.console.println("Writing to the configuration file");
        this.idfToolSet.setId(this.idfToolSet.hashCode());
        this.toolSetConfigurationManager.export(this.idfToolSet);
        this.console.println(Messages.ToolsInstallationJobCompletedMessage);
        return Status.OK_STATUS;
    }

    private void logToConsole(String message, MessageConsoleStream stream) {
        try {
            stream.write(message);
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
    }

    protected IStatus handleToolsInstall() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("install");
        arguments.add("all");
        this.console.println(Messages.InstallToolsHandler_InstallingToolsMsg);
        this.console.println(Messages.InstallToolsHandler_ItWilltakeTimeMsg);
        return this.runCommand(arguments, this.console);
    }

    protected IStatus handleToolsInstallPython(MessageConsoleStream console) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("install-python-env");
        return this.runCommand(arguments, console);
    }
}

