/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.templates;

import com.espressif.idf.core.IDFProjectNature;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.FileUtil;
import com.espressif.idf.ui.UIPlugin;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.cmake.core.CMakeProjectGenerator;
import org.eclipse.cdt.core.build.CBuilder;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.framework.Bundle;

public class IDFProjectGenerator
extends CMakeProjectGenerator {
    private File sourceTemplatePath;
    private boolean copyIntoWorkspace;
    protected MessageConsoleStream console;

    public IDFProjectGenerator(String manifestFile, File source, boolean copyIntoWorkspace, String target) {
        super(manifestFile);
        this.sourceTemplatePath = source;
        this.copyIntoWorkspace = copyIntoWorkspace;
    }

    protected void initProjectDescription(IProjectDescription description) {
        description.setNatureIds(new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature", IDFProjectNature.ID});
        ICommand command = description.newCommand();
        CBuilder.setupBuilder((ICommand)command);
        description.setBuildSpec(new ICommand[]{command});
        if (!this.copyIntoWorkspace) {
            description.setLocation((IPath)new Path(this.sourceTemplatePath.getAbsolutePath()));
        }
    }

    public void generate(Map<String, Object> model, IProgressMonitor monitor) throws CoreException {
        super.generate(model, monitor);
        Logger.log((String)("Source Template path:" + String.valueOf(this.sourceTemplatePath)));
        if (this.sourceTemplatePath == null) {
            this.getProject().refreshLocal(2, monitor);
            return;
        }
        IProject project = this.getProject();
        if (this.copyIntoWorkspace) {
            try {
                this.copyIDFTemplateToWorkspace(project.getName(), this.sourceTemplatePath, project);
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
        project.refreshLocal(2, monitor);
    }

    public Bundle getSourceBundle() {
        return UIPlugin.getDefault().getBundle();
    }

    protected void copyIDFTemplateToWorkspace(String projectName, File sourceTemplateFile, IProject targetProject) throws IOException {
        File[] files;
        File projectFile = targetProject.getLocation().toFile();
        File[] fileArray = files = sourceTemplateFile.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.getName().equals("build")) {
                File dest = new File(projectFile, file.getName());
                if (file.isDirectory()) {
                    FileUtil.copyDirectory((File)file, (File)dest);
                } else {
                    FileUtil.copyFile((File)file, (File)dest);
                }
            }
            ++n2;
        }
    }
}

