/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.size;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.handlers.EclipseHandler;
import com.espressif.idf.ui.size.IDFSizeAnalysisEditor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class IDFSizeMemoryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = EclipseHandler.getSelectedProject("org.eclipse.ui.navigator.ProjectExplorer");
        if (project == null) {
            project = EclipseHandler.getSelectedResource((IEvaluationContext)event.getApplicationContext());
        }
        if (project == null) {
            Logger.log((String)"There is no project selected in the Project Explorer");
            return null;
        }
        IPath mapFilePath = IDFUtil.getMapFilePath((IProject)project);
        Logger.log((String)("Mapping file path " + String.valueOf(mapFilePath)));
        if (mapFilePath == null || !mapFilePath.toFile().exists()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Could not find .map file for project");
            return null;
        }
        try {
            this.launchEditor(mapFilePath, project);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return null;
    }

    private void launchEditor(IPath mapFilePath, IProject project) throws CoreException {
        IFolder buildRootFolder;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile iFile = workspace.getRoot().getFileForLocation(mapFilePath);
        if (mapFilePath.toFile().exists() && iFile == null && !(iFile = (buildRootFolder = project.getFolder("build")).getFile(mapFilePath.lastSegment())).exists()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (!buildRootFolder.exists()) {
                buildRootFolder.create(1025, true, (IProgressMonitor)monitor);
            }
            iFile.createLink(mapFilePath, 0, null);
        }
        final FileEditorInput editorInput = new FileEditorInput(iFile);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow activeww = EclipseHandler.getActiveWorkbenchWindow();
                try {
                    IDE.openEditor((IWorkbenchPage)activeww.getActivePage(), (IEditorInput)editorInput, (String)IDFSizeAnalysisEditor.EDITOR_ID);
                }
                catch (PartInitException e) {
                    Logger.log((Exception)((Object)e));
                }
            }
        });
    }
}

