/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.size;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.size.vo.LibraryMemoryComponent;
import com.espressif.idf.ui.size.vo.MemoryType;
import com.espressif.idf.ui.size.vo.Section;
import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class IDFSizeDataManager {
    public List<LibraryMemoryComponent> getDataList(IFile mapFile) throws Exception {
        JSONObject archivesJsonObj;
        String pythonExecutablePath = this.preconditionsCheck();
        List<String> arguments = this.getCommandArgsArchives(pythonExecutablePath, mapFile);
        String detailsJsonOp = this.getOutput(mapFile, arguments);
        if (!StringUtil.isEmpty((String)detailsJsonOp) && (archivesJsonObj = this.getJSON(detailsJsonOp)) != null) {
            JSONObject symbolJsonObj = this.getSymbolDetails(pythonExecutablePath, mapFile);
            return this.convertToViewerModel(archivesJsonObj, symbolJsonObj);
        }
        return Collections.EMPTY_LIST;
    }

    public JSONObject getIDFSizeOverview(IFile mapFile, String targetName) throws Exception {
        String pythonExecutablePath = this.preconditionsCheck();
        List<String> commandArgs = this.getCommandArgs(pythonExecutablePath, mapFile, targetName);
        String detailsJsonOp = this.getOutput(mapFile, commandArgs);
        if (!StringUtil.isEmpty((String)(detailsJsonOp = detailsJsonOp.replace("NaN", "0")))) {
            return this.getJSON(detailsJsonOp);
        }
        return null;
    }

    protected String preconditionsCheck() throws Exception {
        String pythonExecutablePath = IDFUtil.getIDFPythonEnvPath();
        if (StringUtil.isEmpty((String)pythonExecutablePath)) {
            throw new Exception("IDF_PYTHON_ENV_PATH path is not found in the Eclispe CDT build environment variables");
        }
        return pythonExecutablePath;
    }

    private List<LibraryMemoryComponent> convertToViewerModel(JSONObject archivesJsonObj, JSONObject symbolJsonObj) {
        ArrayList<LibraryMemoryComponent> arrayList = new ArrayList<LibraryMemoryComponent>();
        Set keySet = archivesJsonObj.keySet();
        for (String key : keySet) {
            JSONObject object = (JSONObject)archivesJsonObj.get((Object)key);
            LibraryMemoryComponent record = this.getSizeRecord(key, object);
            arrayList.add(record);
            if (symbolJsonObj == null) continue;
            Set symbolsKeySet = symbolJsonObj.keySet();
            for (String symbolsKey : symbolsKeySet) {
                if (!symbolsKey.startsWith(key)) continue;
                String symbolName = symbolsKey.substring(key.length() + 1);
                JSONObject symbolObj = (JSONObject)symbolJsonObj.get((Object)symbolsKey);
                record.getChildren().add(this.getSizeRecord(symbolName, symbolObj));
            }
        }
        return arrayList;
    }

    protected LibraryMemoryComponent getSizeRecord(String key, JSONObject object) {
        LibraryMemoryComponent library = new LibraryMemoryComponent();
        String[] keySplit = key.split("/");
        String nameToSet = keySplit[keySplit.length - 1] + " -> " + key;
        library.setName(nameToSet);
        library.setAbbrevName((String)object.get((Object)"abbrev_name"));
        library.setSize(this.getValue(object.get((Object)"size")));
        library.setSizeDiff(this.getValue(object.get((Object)"size_diff")));
        LinkedHashMap<String, MemoryType> memoryTypesMap = new LinkedHashMap<String, MemoryType>();
        JSONObject memoryTypesJson = (JSONObject)object.get((Object)"memory_types");
        for (Object memoryKeyObj : memoryTypesJson.keySet()) {
            String memoryKey = (String)memoryKeyObj;
            JSONObject memoryTypeJson = (JSONObject)memoryTypesJson.get((Object)memoryKey);
            MemoryType memoryType = new MemoryType();
            memoryType.setSize(this.getValue(memoryTypeJson.get((Object)"size")));
            memoryType.setSizeDiff(this.getValue(memoryTypeJson.get((Object)"size_diff")));
            JSONObject sectionsJson = (JSONObject)memoryTypeJson.get((Object)"sections");
            LinkedHashMap<String, Section> sectionsMap = new LinkedHashMap<String, Section>();
            for (Object sectionKeyObj : sectionsJson.keySet()) {
                String sectionKey = (String)sectionKeyObj;
                JSONObject sectionJson = (JSONObject)sectionsJson.get((Object)sectionKey);
                Section section = new Section();
                section.setSize(this.getValue(sectionJson.get((Object)"size")));
                section.setSizeDiff(this.getValue(sectionJson.get((Object)"size_diff")));
                section.setAbbrevName((String)sectionJson.get((Object)"abbrev_name"));
                sectionsMap.put(sectionKey, section);
            }
            memoryType.setSections(sectionsMap);
            memoryTypesMap.put(memoryKey, memoryType);
        }
        library.setMemoryTypes(memoryTypesMap);
        return library;
    }

    protected long getValue(Object object) {
        return object != null ? (Long)object : 0L;
    }

    private JSONObject getSymbolDetails(String pythonExecutablePath, IFile mapFile) {
        List<String> arguments = this.getCommandArgsSymbolDetails(pythonExecutablePath, mapFile);
        String symbolsJsonOp = this.getOutput(mapFile, arguments);
        if (!StringUtil.isEmpty((String)symbolsJsonOp)) {
            return this.getJSON(symbolsJsonOp);
        }
        return null;
    }

    protected String getOutput(IFile mapFile, List<String> arguments) {
        try {
            Logger.log((String)arguments.toString());
            IStatus status = this.runProcess(mapFile, arguments);
            String message = status.getMessage();
            Logger.log((String)message);
            if (status.isOK() && !StringUtil.isEmpty((String)message)) {
                return status.getMessage();
            }
        }
        catch (Exception e) {
            Logger.log((Exception)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)e.getMessage());
        }
        return null;
    }

    protected IStatus runProcess(IFile file, List<String> arguments) throws Exception {
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            return processRunner.runInBackground(arguments, (IPath)Path.ROOT, IDFUtil.getSystemEnv());
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
            return new Status(4, "com.espressif.idf.ui", e1.getMessage());
        }
    }

    protected List<String> getCommandArgsArchives(String pythonExecutablenPath, IFile file) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(pythonExecutablenPath);
        arguments.add(IDFUtil.getIDFSizeScriptFile().getAbsolutePath());
        arguments.add(file.getLocation().toOSString());
        arguments.add("--archives");
        arguments.addAll(this.addJsonParseCommand());
        return arguments;
    }

    private List<String> addJsonParseCommand() {
        String idfVersion;
        ArrayList<String> arguments = new ArrayList<String>();
        IEnvironmentVariable idfVersionEnv = new IDFEnvironmentVariables().getEnv("ESP_IDF_VERSION");
        String string = idfVersion = idfVersionEnv != null ? idfVersionEnv.getValue() : null;
        if (idfVersion != null && this.isVersionAtLeast(idfVersion, "5.1")) {
            arguments.add("--format");
            arguments.add("json2");
        } else {
            arguments.add("--json");
        }
        return arguments;
    }

    public boolean isVersionAtLeast(String currentIDFVersion, String minimumIDFVersion) {
        ModuleDescriptor.Version minVersion;
        ModuleDescriptor.Version currentVersion = ModuleDescriptor.Version.parse(currentIDFVersion);
        return currentVersion.compareTo(minVersion = ModuleDescriptor.Version.parse(minimumIDFVersion)) >= 0;
    }

    protected List<String> getCommandArgsSymbolDetails(String pythonExecutablenPath, IFile file) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(pythonExecutablenPath);
        arguments.add(IDFUtil.getIDFSizeScriptFile().getAbsolutePath());
        arguments.add(file.getLocation().toOSString());
        arguments.add("--file");
        arguments.addAll(this.addJsonParseCommand());
        return arguments;
    }

    protected List<String> getCommandArgs(String pythonExecutablenPath, IFile file, String targetName) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(pythonExecutablenPath);
        arguments.add("-m");
        arguments.add("esp_idf_size");
        arguments.add("--ng");
        arguments.add("--format");
        arguments.add("json2");
        arguments.add(file.getLocation().toOSString());
        return arguments;
    }

    protected JSONObject getJSON(String jsonOutput) {
        JSONObject jsonObj = null;
        if (jsonOutput.indexOf("{") != 0) {
            int begin = jsonOutput.indexOf("{") - 1;
            int end = jsonOutput.lastIndexOf("}") + 1;
            jsonOutput = jsonOutput.substring(begin, end);
        }
        try {
            jsonObj = (JSONObject)new JSONParser().parse(jsonOutput);
            return jsonObj;
        }
        catch (ParseException e) {
            Logger.log((Exception)((Object)e));
            return jsonObj;
        }
    }
}

