/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.nvs.dialog;

import com.espressif.idf.ui.nvs.dialog.NvsCsvEditorPage;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.EditorPart;

public class NvsEditor
extends EditorPart {
    public static final String ID = "com.espressif.idf.ui.nvs.nvsEditor";
    private NvsCsvEditorPage editorPage;
    private IFile csvFile;
    private boolean isDirty = false;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.csvFile = ResourceUtil.getFile((IEditorInput)input);
        if (this.csvFile == null) {
            throw new PartInitException("Editor input must be a file resource.");
        }
        this.setPartName(this.csvFile.getName());
        this.setTitleToolTip(this.csvFile.getFullPath().toString());
    }

    public void createPartControl(Composite parent) {
        Consumer<Boolean> dirtyStateListener = this::setDirty;
        this.editorPage = new NvsCsvEditorPage(parent, this.csvFile, dirtyStateListener);
        this.editorPage.createControl();
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask("Saving NVS table...", -1);
        boolean saveSuccessful = this.editorPage.getSaveAction();
        if (saveSuccessful) {
            this.setDirty(false);
        }
        monitor.done();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
            if (this.editorPage != null) {
                this.editorPage.updateErrorMessage();
            }
        }
    }

    public void setFocus() {
        if (this.editorPage != null) {
            this.editorPage.setFocus();
        }
    }
}

