/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.installcomponents.container;

import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.installcomponents.container.ComponentContainer;
import com.espressif.idf.ui.installcomponents.deserializer.ComponentsDeserializer;
import com.espressif.idf.ui.installcomponents.vo.ComponentVO;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;

public class InstallComponentsCompositePage {
    private IFile componentsJsonFile;
    private IProject project;
    private List<ComponentVO> componentVOs;
    private List<ComponentContainer> componentContainers;

    public InstallComponentsCompositePage(IFile componentsJsonFile, IProject project) {
        this.componentsJsonFile = componentsJsonFile;
        this.project = project;
        this.componentContainers = new ArrayList<ComponentContainer>();
    }

    public void createControls(Composite parent) throws IOException {
        this.loadComponents();
        for (ComponentVO componentVO : this.componentVOs) {
            this.setComponentAdded(componentVO);
            ComponentContainer componentContainer = new ComponentContainer(componentVO, parent, this.project);
            componentContainer.createControl();
            this.componentContainers.add(componentContainer);
        }
    }

    private void setComponentAdded(ComponentVO componentVO) throws IOException {
        String toMatch = componentVO.getNamespace().concat("/").concat(componentVO.getName());
        IFile file = this.componentsJsonFile.getProject().getFolder("main").getFile("idf_component.yml");
        if (file.exists()) {
            List<String> ymlEntries = Files.readAllLines(file.getLocation().toFile().toPath());
            for (String ymlEntry : ymlEntries) {
                if (!StringUtil.isEmpty((String)ymlEntry) && ymlEntry.charAt(0) == '#' || !ymlEntry.contains(toMatch)) continue;
                componentVO.setComponentAdded(true);
                return;
            }
        }
    }

    private void loadComponents() throws IOException {
        String jsonString = Files.readString(this.componentsJsonFile.getLocation().toFile().toPath());
        Gson gson = new GsonBuilder().registerTypeAdapter(ArrayList.class, (Object)new ComponentsDeserializer()).setPrettyPrinting().disableHtmlEscaping().create();
        JsonArray jsonArray = (JsonArray)gson.fromJson(jsonString, JsonArray.class);
        this.componentVOs = (List)gson.fromJson(jsonArray.toString(), ArrayList.class);
    }

    public void dispose() {
        for (ComponentContainer componentContainer : this.componentContainers) {
            componentContainer.dispose();
        }
    }
}

