/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.handlers;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.LspService;
import com.espressif.idf.core.util.StringUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.FileEditorInput;

public class FileOpenListener
implements IPartListener2 {
    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IEditorPart ieditorpart;
        IEditorInput iEditorInput;
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof IEditorPart && (iEditorInput = (ieditorpart = (IEditorPart)part).getEditorInput()) instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)iEditorInput;
            IFile file = fileInput.getFile();
            IProject project = file.getProject();
            if (project == null) {
                return;
            }
            if (!this.isSourceOrHeaderFile(file)) {
                return;
            }
            String buildDir = "";
            try {
                buildDir = IDFUtil.getBuildDir((IProject)project);
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
            }
            if (StringUtil.isEmpty((String)buildDir)) {
                return;
            }
            LspService lspService = new LspService();
            lspService.updateCompileCommandsDir(buildDir);
            lspService.restartLspServers();
        }
    }

    private boolean isSourceOrHeaderFile(IFile file) {
        try {
            String id;
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            IContentType contentType = contentTypeManager.findContentTypeFor(file.getFullPath().toOSString());
            if (contentType != null && (id = contentType.getId()).startsWith("org.eclipse.cdt.core.c") && (id.endsWith("Source") || id.endsWith("Header"))) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.log((Exception)e);
        }
        return false;
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

