/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.dialogs;

import com.espressif.idf.core.build.ReHintPair;
import com.espressif.idf.core.util.HintsUtil;
import com.espressif.idf.ui.dialogs.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class BuildView
extends ViewPart {
    private TableViewer hintsTableViewer;
    private final String[] titles = new String[]{Messages.BuildView_ErrorMsgLbl, Messages.BuildView_HintMsgLbl};
    private List<ReHintPair> reHintsPairs = Collections.emptyList();
    private Composite parent;
    private Composite container;

    public void updateReHintsPairs(List<ReHintPair> reHintPairs) {
        this.reHintsPairs = reHintPairs;
        this.container.dispose();
        this.createPartControl(this.parent);
        this.parent.pack();
        this.parent.layout(true);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.container = new Composite(this.parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, true);
        this.container.setLayout((Layout)layout);
        if (this.reHintsPairs.isEmpty()) {
            if (!new File(HintsUtil.getHintsYmlPath()).exists()) {
                this.createNoHintsYmlLabel();
            } else {
                this.createNoAvailableHintsLabel();
            }
            return;
        }
        this.createHintsViewer(this.container);
    }

    private void createNoAvailableHintsLabel() {
        CLabel infoField = new CLabel(this.container, 256);
        infoField.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        infoField.setText(Messages.BuildView_NoAvailableHintsMsg);
    }

    private void createNoHintsYmlLabel() {
        CLabel errorField = new CLabel(this.container, 256);
        errorField.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        errorField.setText(MessageFormat.format(Messages.HintsYmlNotFoundErrMsg, HintsUtil.getHintsYmlPath()));
    }

    private void createHintsViewer(Composite container) {
        this.hintsTableViewer = new TableViewer(container, 68354);
        this.createColumns(container);
        Table hintsTable = this.hintsTableViewer.getTable();
        hintsTable.setHeaderVisible(true);
        hintsTable.setLinesVisible(true);
        this.hintsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.hintsTableViewer.setInput(this.reHintsPairs);
        this.resizeAllColumns();
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.hintsTableViewer.getControl().setLayoutData((Object)gridData);
    }

    private void resizeAllColumns() {
        TableColumn[] tableColumnArray = this.hintsTableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.pack();
            ++n2;
        }
    }

    private void createColumns(Composite container) {
        TableViewerColumn col = this.createTableViewerColumn(this.titles[0]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }

            public String getText(Object element) {
                Optional reOptionalPattern = ((ReHintPair)element).getRe();
                return reOptionalPattern.isPresent() ? ((Pattern)reOptionalPattern.get()).pattern() : "";
            }
        });
        col = this.createTableViewerColumn(this.titles[1]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }

            public String getText(Object element) {
                return ((ReHintPair)element).getHint();
            }
        });
        col.getViewer().addDoubleClickListener(event -> {
            StructuredSelection selection = (StructuredSelection)event.getViewer().getSelection();
            MessageDialog.openInformation((Shell)container.getShell(), (String)Messages.HintDetailsTitle, (String)((ReHintPair)selection.getFirstElement()).getHint());
        });
    }

    private TableViewerColumn createTableViewerColumn(String title) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.hintsTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void setFocus() {
    }
}

