/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.menu.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.export.core.AbstractSeriesExportHandler;
import org.eclipse.swtchart.export.core.AxisSettings;
import org.eclipse.swtchart.export.core.ISeriesExportConverter;
import org.eclipse.swtchart.export.core.VectorExportSettingsDialog;
import org.eclipse.swtchart.export.menu.text.Messages;
import org.eclipse.swtchart.extensions.barcharts.BarChart;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ChartType;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.linecharts.LineChart;
import org.eclipse.swtchart.extensions.linecharts.StepChart;
import org.eclipse.swtchart.extensions.scattercharts.ScatterChart;

public class RScriptExportHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    private static final String FILE_EXTENSION = "*.R";
    public static final String NAME = MessageFormat.format(Messages.getString("IMAGE_R_SCRIPT"), "*.R");
    private static final String TITLE = Messages.getString("SAVE_AS_IMAGE_R_SCRIPT");
    private static final String AXIS_X = "x";
    private static final String AXIS_Y = "y";
    private Map<ILineSeries.PlotSymbolType, Integer> plotSymbolsMap;
    private Map<LineStyle, Integer> lineStylesMap;

    public String getName() {
        return NAME;
    }

    public Image getIcon() {
        return ResourceSupport.getImage((String)"r.gif");
    }

    public void execute(Shell shell, ScrollableChart scrollableChart) {
        BaseChart baseChart = scrollableChart.getBaseChart();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText(TITLE);
        fileDialog.setFilterExtensions(new String[]{FILE_EXTENSION});
        fileDialog.setFileName(scrollableChart.getFileName());
        String fileName = fileDialog.open();
        if (fileName != null) {
            VectorExportSettingsDialog exportSettingsDialog = new VectorExportSettingsDialog(shell, baseChart);
            exportSettingsDialog.create();
            if (exportSettingsDialog.open() == 0) {
                int indexAxisX = exportSettingsDialog.getIndexAxisSelectionX();
                int indexAxisY = exportSettingsDialog.getIndexAxisSelectionY();
                if (indexAxisX >= 0 && indexAxisY >= 0) {
                    Object secondaryAxisSettings;
                    IAxisSettings axisSettingsX = baseChart.getXAxisSettings(indexAxisX);
                    IAxisScaleConverter axisScaleConverterX = null;
                    if (axisSettingsX instanceof ISecondaryAxisSettings) {
                        ISecondaryAxisSettings secondaryAxisSettings2 = (ISecondaryAxisSettings)axisSettingsX;
                        axisScaleConverterX = secondaryAxisSettings2.getAxisScaleConverter();
                    }
                    IAxisSettings axisSettingsY = baseChart.getYAxisSettings(indexAxisY);
                    IAxisScaleConverter axisScaleConverterY = null;
                    if (axisSettingsY instanceof ISecondaryAxisSettings) {
                        secondaryAxisSettings = (ISecondaryAxisSettings)axisSettingsY;
                        axisScaleConverterY = secondaryAxisSettings.getAxisScaleConverter();
                    }
                    try {
                        secondaryAxisSettings = null;
                        Object var14_16 = null;
                        try (PrintWriter printWriter = new PrintWriter(new File(fileName));){
                            AxisSettings axisSettings = new AxisSettings();
                            axisSettings.setIndexAxisX(indexAxisX);
                            axisSettings.setIndexAxisY(indexAxisY);
                            axisSettings.setAxisSettingsX(axisSettingsX);
                            axisSettings.setAxisScaleConverterX(axisScaleConverterX);
                            axisSettings.setAxisSettingsY(axisSettingsY);
                            axisSettings.setAxisScaleConverterY(axisScaleConverterY);
                            this.plotSymbolsMap = new HashMap<ILineSeries.PlotSymbolType, Integer>();
                            this.plotSymbolsMap.put(ILineSeries.PlotSymbolType.CIRCLE, 1);
                            this.plotSymbolsMap.put(ILineSeries.PlotSymbolType.CROSS, 4);
                            this.plotSymbolsMap.put(ILineSeries.PlotSymbolType.DIAMOND, 5);
                            this.plotSymbolsMap.put(ILineSeries.PlotSymbolType.INVERTED_TRIANGLE, 6);
                            this.plotSymbolsMap.put(ILineSeries.PlotSymbolType.PLUS, 3);
                            this.plotSymbolsMap.put(ILineSeries.PlotSymbolType.SQUARE, 0);
                            this.plotSymbolsMap.put(ILineSeries.PlotSymbolType.TRIANGLE, 2);
                            this.plotSymbolsMap.put(ILineSeries.PlotSymbolType.NONE, 20);
                            this.lineStylesMap = new HashMap<LineStyle, Integer>();
                            this.lineStylesMap.put(LineStyle.NONE, 0);
                            this.lineStylesMap.put(LineStyle.DASH, 2);
                            this.lineStylesMap.put(LineStyle.DASHDOT, 4);
                            this.lineStylesMap.put(LineStyle.DASHDOTDOT, 6);
                            this.lineStylesMap.put(LineStyle.DOT, 3);
                            this.lineStylesMap.put(LineStyle.SOLID, 1);
                            if (scrollableChart instanceof LineChart) {
                                this.printLinePlot(fileName, printWriter, scrollableChart, axisSettings);
                            } else if (scrollableChart instanceof BarChart) {
                                this.printBarPlot(fileName, printWriter, scrollableChart, axisSettings);
                            } else if (scrollableChart instanceof ScatterChart) {
                                this.printScatterPlot(fileName, printWriter, scrollableChart, axisSettings);
                            } else if (scrollableChart instanceof StepChart) {
                                this.printStepPlot(fileName, printWriter, scrollableChart, axisSettings);
                            } else {
                                ChartType chartType = scrollableChart.getChartType();
                                switch (chartType) {
                                    case LINE: {
                                        this.printLinePlot(fileName, printWriter, scrollableChart, axisSettings);
                                        break;
                                    }
                                    case BAR: {
                                        this.printBarPlot(fileName, printWriter, scrollableChart, axisSettings);
                                        break;
                                    }
                                    case SCATTER: {
                                        this.printScatterPlot(fileName, printWriter, scrollableChart, axisSettings);
                                        break;
                                    }
                                    case STEP: {
                                        this.printStepPlot(fileName, printWriter, scrollableChart, axisSettings);
                                        break;
                                    }
                                    default: {
                                        System.out.println("The chart type export is not supported: " + String.valueOf(chartType));
                                    }
                                }
                            }
                            printWriter.flush();
                            MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)MESSAGE_OK);
                        }
                        catch (Throwable throwable) {
                            if (secondaryAxisSettings == null) {
                                secondaryAxisSettings = throwable;
                            } else if (secondaryAxisSettings != throwable) {
                                ((Throwable)secondaryAxisSettings).addSuppressed(throwable);
                            }
                            throw secondaryAxisSettings;
                        }
                    }
                    catch (FileNotFoundException e) {
                        MessageDialog.openError((Shell)shell, (String)TITLE, (String)MESSAGE_ERROR);
                        e.printStackTrace();
                    }
                }
            }
            exportSettingsDialog.reset();
            scrollableChart.updateLegend();
        }
    }

    private String getColor(Color color) {
        double[] rgb;
        StringBuilder hex_color = new StringBuilder("#");
        double r = color.getRed();
        double g = color.getGreen();
        double b = color.getBlue();
        double[] dArray = rgb = new double[]{r, g, b};
        int n = rgb.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            double hex = 16.0;
            double div = x / hex;
            int count = (int)div;
            double rem = div - (double)count;
            rem = (int)(rem * hex);
            char first = count >= 10 ? (char)(97 + (count - 10)) : (char)(48 + count);
            char second = rem >= 10.0 ? (char)(97.0 + (rem - 10.0)) : (char)(48.0 + rem);
            hex_color.append(first);
            hex_color.append(second);
            ++n2;
        }
        return hex_color.toString();
    }

    private void printLinePlot(String fileName, PrintWriter printWriter, ScrollableChart scrollableChart, AxisSettings axisSettings) {
        ISeries dataSeries;
        Object style;
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        BaseChart baseChart = scrollableChart.getBaseChart();
        ISeries[] series = baseChart.getSeriesSet().getSeries();
        this.printExecuteInfo(fileName, printWriter);
        int seriesSize = this.getSeriesSize(series);
        printWriter.println("# Header");
        printWriter.println("xValueList<-vector(\"list\", " + seriesSize + ")");
        printWriter.println("yValueList<-vector(\"list\", " + seriesSize + ")");
        printWriter.println("");
        printWriter.println("# Data");
        int widthPlotArea = baseChart.getPlotArea().getSize().x;
        int index = 1;
        ArrayList<String> color = new ArrayList<String>();
        ArrayList<Integer> plotSymbols = new ArrayList<Integer>();
        ArrayList<Integer> lineStyles = new ArrayList<Integer>();
        ArrayList<Character> lineTypes = new ArrayList<Character>();
        ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries dataSeries2 = iSeriesArray[n2];
            if (dataSeries2 != null && dataSeries2.isVisible()) {
                ILineSeries lineSeries = (ILineSeries)dataSeries2;
                Color col = lineSeries.getLineColor();
                color.add(this.getColor(col));
                ILineSeries.PlotSymbolType series_symbol = lineSeries.getSymbolType();
                style = lineSeries.getLineStyle();
                plotSymbols.add(this.plotSymbolsMap.get(series_symbol));
                if (series_symbol == ILineSeries.PlotSymbolType.NONE) {
                    lineTypes.add(Character.valueOf('l'));
                } else {
                    lineTypes.add(Character.valueOf('b'));
                }
                lineStyles.add(this.lineStylesMap.get(style));
                this.printLineData(dataSeries2, widthPlotArea, axisSettings, index++, printWriter);
            }
            ++n2;
        }
        printWriter.println("");
        printWriter.println("#  Footer");
        StringBuilder list = new StringBuilder("colorList<-c(");
        int length1 = color.size();
        int color_count = 0;
        for (String col : color) {
            list.append("\"");
            list.append(col);
            list.append("\"");
            if (color_count == length1 - 1) continue;
            list.append(",");
            ++color_count;
        }
        list.append(")");
        printWriter.println(list);
        StringBuilder plotSymbol_List = new StringBuilder("symbolList<-c(");
        int length2 = plotSymbols.size();
        int symbol_count = 0;
        style = plotSymbols.iterator();
        while (style.hasNext()) {
            int symbol = (Integer)style.next();
            plotSymbol_List.append(symbol);
            if (symbol_count == length2 - 1) continue;
            plotSymbol_List.append(",");
            ++symbol_count;
        }
        plotSymbol_List.append(")");
        printWriter.println(plotSymbol_List);
        StringBuilder lineStyle_List = new StringBuilder("styleList<-c(");
        int length3 = lineStyles.size();
        int style_count = 0;
        Iterator iterator = lineStyles.iterator();
        while (iterator.hasNext()) {
            int style2 = (Integer)iterator.next();
            lineStyle_List.append(style2);
            if (style_count == length3 - 1) continue;
            lineStyle_List.append(",");
            ++style_count;
        }
        lineStyle_List.append(")");
        printWriter.println(lineStyle_List);
        StringBuilder lineType_List = new StringBuilder("typeList<-c(");
        int length4 = lineTypes.size();
        int type_count = 0;
        Iterator iterator2 = lineTypes.iterator();
        while (iterator2.hasNext()) {
            char type = ((Character)iterator2.next()).charValue();
            lineType_List.append("\"");
            lineType_List.append(type);
            lineType_List.append("\"");
            if (type_count == length4 - 1) continue;
            lineType_List.append(",");
            ++type_count;
        }
        lineType_List.append(")");
        printWriter.println(lineType_List);
        printWriter.println("");
        printWriter.println("plot(");
        printWriter.println("\txValueList[[1]], yValueList[[1]],");
        printWriter.println("\txlim=c(range(xValueList)[1], range(xValueList)[2]),");
        printWriter.println("\tylim=c(range(yValueList)[1], range(yValueList)[2]),");
        printWriter.println("\ttype=typeList[1],");
        printWriter.println("\tcol=colorList[1],");
        printWriter.println("\tpch=symbolList[1],");
        printWriter.println("\tlty= styleList[1],");
        printWriter.println("\tylab='" + axisSettingsY.getLabel() + "',");
        printWriter.println("\txlab='" + axisSettingsX.getLabel() + "'");
        printWriter.println(")");
        printWriter.println("");
        if (seriesSize > 1) {
            printWriter.println("for(i in 2:" + seriesSize + "){");
            printWriter.println("\tlines(xValueList[[i]], yValueList[[i]], type=typeList[i],lty=styleList[i], col=colorList[i], pch=symbolList[i])");
            printWriter.println("}");
            printWriter.println("");
        }
        int size = seriesSize;
        printWriter.println("legend('topleft',");
        printWriter.println("\t\tc(");
        int k = 0;
        ISeries[] iSeriesArray2 = series;
        int n3 = series.length;
        int n4 = 0;
        while (n4 < n3) {
            dataSeries = iSeriesArray2[n4];
            if (dataSeries != null && dataSeries.isVisible()) {
                printWriter.print("\t\t\t'Series " + dataSeries.getDescription() + "'");
                if (k < size - 1) {
                    printWriter.print(",");
                }
                printWriter.println();
                ++k;
            }
            ++n4;
        }
        printWriter.println("\t\t),");
        printWriter.println("\t\tcol=c(");
        k = 0;
        iSeriesArray2 = series;
        n3 = series.length;
        n4 = 0;
        while (n4 < n3) {
            dataSeries = iSeriesArray2[n4];
            if (dataSeries != null && dataSeries.isVisible()) {
                printWriter.print("\t\t\tcolorList[" + (k + 1) + "]");
                if (k < size - 1) {
                    printWriter.print(",");
                }
                printWriter.println();
                ++k;
            }
            ++n4;
        }
        printWriter.println("\t\t),");
        printWriter.println("\t\tlwd=2");
        printWriter.println("\t)");
        printWriter.println("");
    }

    private void printLineData(ISeries<?> dataSeries, int widthPlotArea, AxisSettings axisSettings, int index, PrintWriter printWriter) {
        int indexAxisX = axisSettings.getIndexAxisX();
        int indexAxisY = axisSettings.getIndexAxisY();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        int size = dataSeries.getXSeries().length;
        int i = 0;
        while (i < size) {
            Point point = dataSeries.getPixelCoordinates(i);
            if (point.x >= 0 && point.x <= widthPlotArea) {
                this.printValueLinePlot(AXIS_X, index, printWriter, xSeries[i], indexAxisX, 0, axisScaleConverterX);
                this.printValueLinePlot(AXIS_Y, index, printWriter, ySeries[i], indexAxisY, 0, axisScaleConverterY);
            }
            ++i;
        }
    }

    private void printValueLinePlot(String axis, int index, PrintWriter printWriter, double value, int indexAxis, int indexPrimaryAxis, IAxisScaleConverter axisScaleConverter) {
        if (indexAxis == indexPrimaryAxis || axisScaleConverter == null) {
            if (axis.equals(AXIS_X)) {
                printWriter.println("xValueList[[" + index + "]]<-c(xValueList[[" + index + "]]," + value + ")");
            } else if (axis.equals(AXIS_Y)) {
                printWriter.println("yValueList[[" + index + "]]<-c(yValueList[[" + index + "]]," + value + ")");
            }
        } else if (axisScaleConverter != null) {
            if (axis.equals(AXIS_X)) {
                printWriter.println("xValueList[[" + index + "]]<-c(xValueList[[" + index + "]]," + axisScaleConverter.convertToSecondaryUnit(value) + ")");
            } else if (axis.equals(AXIS_Y)) {
                printWriter.println("yValueList[[" + index + "]]<-c(yValueList[[" + index + "]]," + axisScaleConverter.convertToSecondaryUnit(value) + ")");
            }
        }
    }

    private void printBarPlot(String fileName, PrintWriter printWriter, ScrollableChart scrollableChart, AxisSettings axisSettings) {
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        BaseChart baseChart = scrollableChart.getBaseChart();
        ISeries[] series = baseChart.getSeriesSet().getSeries();
        this.printExecuteInfo(fileName, printWriter);
        printWriter.println("# Header");
        printWriter.println("count_values<-NULL");
        printWriter.println("");
        printWriter.println("# Data");
        int widthPlotArea = baseChart.getPlotArea().getSize().x;
        ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries dataSeries = iSeriesArray[n2];
            if (dataSeries != null && dataSeries.isVisible()) {
                this.printBarData(dataSeries, widthPlotArea, axisSettings, printWriter);
            }
            ++n2;
        }
        printWriter.println("");
        printWriter.println("#  Footer");
        printWriter.println("hist(count_values, breaks = range(count_values)[2]-range(count_values)[1]+1, axes=FALSE, xlab='" + axisSettingsX.getLabel() + "', ylab='" + axisSettingsY.getLabel() + "', main='" + scrollableChart.getChartSettings().getTitle() + "')");
        printWriter.println("");
        printWriter.println("axis(2, at = NULL)");
        printWriter.println("lower_x <- NULL");
        printWriter.println("if(min(count_values) %% 10 != 0){");
        printWriter.println("  lower_x <- round(min(count_values) %/% 10,0)*10");
        printWriter.println("} else {");
        printWriter.println("  lower_x <- min(count_values)+0.5");
        printWriter.println("}");
        printWriter.println("");
        printWriter.println("upper_x <- round(max(count_values)/10,0)*10+0.5");
        printWriter.println("axis(1, at = seq(lower_x+0.5, upper_x+0.5, 10), labels=seq(lower_x, upper_x, 10), tick = TRUE )");
    }

    private void printBarData(ISeries<?> dataSeries, int widthPlotArea, AxisSettings axisSettings, PrintWriter printWriter) {
        int indexAxisX = axisSettings.getIndexAxisX();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        int size = dataSeries.getXSeries().length;
        int i = 0;
        while (i < size) {
            Point point = dataSeries.getPixelCoordinates(i);
            if (point.x >= 0 && point.x <= widthPlotArea) {
                boolean isPrimaryAxis = indexAxisX == 0;
                this.printValueBarPlot(printWriter, xSeries[i], ySeries[i], isPrimaryAxis, axisScaleConverterX, axisScaleConverterY);
            }
            ++i;
        }
    }

    private void printValueBarPlot(PrintWriter printWriter, double valueX, double valueY, boolean isPrimaryAxis, IAxisScaleConverter axisScaleConverterX, IAxisScaleConverter axisScaleConverterY) {
        if (isPrimaryAxis || axisScaleConverterX == null || axisScaleConverterY == null) {
            printWriter.println("count_values<-c(count_values, rep(" + valueX + ", " + valueY + "))");
        } else if (axisScaleConverterX != null && axisScaleConverterY != null) {
            printWriter.println("count_values<-c(count_values, rep(" + axisScaleConverterX.convertToSecondaryUnit(valueX) + ", " + axisScaleConverterY.convertToSecondaryUnit(valueY) + "))");
        }
    }

    private void printScatterPlot(String fileName, PrintWriter printWriter, ScrollableChart scrollableChart, AxisSettings axisSettings) {
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        BaseChart baseChart = scrollableChart.getBaseChart();
        ISeries[] series = baseChart.getSeriesSet().getSeries();
        this.printExecuteInfo(fileName, printWriter);
        int seriesSize = this.getSeriesSize(series);
        printWriter.println("# Header");
        printWriter.println("xValueList<-vector(\"list\", " + seriesSize + ")");
        printWriter.println("yValueList<-vector(\"list\", " + seriesSize + ")");
        printWriter.println("");
        printWriter.println("# Data");
        int widthPlotArea = baseChart.getPlotArea().getSize().x;
        int index = 1;
        ArrayList<String> color = new ArrayList<String>();
        ArrayList<Integer> plotSymbols = new ArrayList<Integer>();
        ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries dataSeries = iSeriesArray[n2];
            if (dataSeries != null && dataSeries.isVisible()) {
                ILineSeries lineSeries = (ILineSeries)dataSeries;
                Color col = lineSeries.getSymbolColor();
                color.add(this.getColor(col));
                ILineSeries.PlotSymbolType series_symbol = lineSeries.getSymbolType();
                plotSymbols.add(this.plotSymbolsMap.get(series_symbol));
                this.printLineData(dataSeries, widthPlotArea, axisSettings, index++, printWriter);
            }
            ++n2;
        }
        printWriter.println("");
        printWriter.println("#  Footer");
        StringBuilder list = new StringBuilder("colorList<-c(");
        int length = color.size();
        int color_count = 0;
        for (String col : color) {
            list.append("\"");
            list.append(col);
            list.append("\"");
            if (color_count == length - 1) continue;
            list.append(",");
            ++color_count;
        }
        list.append(")");
        printWriter.println(list);
        StringBuilder plotSymbol_List = new StringBuilder("symbolList<-c(");
        int length2 = plotSymbols.size();
        int symbol_count = 0;
        Iterator iterator = plotSymbols.iterator();
        while (iterator.hasNext()) {
            int symbol = (Integer)iterator.next();
            plotSymbol_List.append(symbol);
            if (symbol_count == length2 - 1) continue;
            plotSymbol_List.append(",");
            ++symbol_count;
        }
        plotSymbol_List.append(")");
        printWriter.println(plotSymbol_List);
        printWriter.println("");
        printWriter.println("plot(");
        printWriter.println("\txValueList[[1]], yValueList[[1]],");
        printWriter.println("\txlim=c(range(xValueList)[1], range(xValueList)[2]),");
        printWriter.println("\tylim=c(range(yValueList)[1], range(yValueList)[2]),");
        printWriter.println("\ttype='p',");
        printWriter.println("\tcol=colorList[1],");
        printWriter.println("\tpch=symbolList[1],");
        printWriter.println("\tylab='" + axisSettingsY.getLabel() + "',");
        printWriter.println("\txlab='" + axisSettingsX.getLabel() + "'");
        printWriter.println(")");
        printWriter.println("");
        if (seriesSize > 1) {
            printWriter.println("for(i in 2:" + seriesSize + "){");
            printWriter.println("\tpoints(xValueList[[i]], yValueList[[i]], type='p', col=colorList[i], pch=symbolList[i])");
            printWriter.println("}");
            printWriter.println("");
        }
        printWriter.println("abline(h=0)");
        printWriter.println("abline(v=0)");
    }

    private void printStepPlot(String fileName, PrintWriter printWriter, ScrollableChart scrollableChart, AxisSettings axisSettings) {
        ISeries dataSeries;
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        BaseChart baseChart = scrollableChart.getBaseChart();
        ISeries[] series = baseChart.getSeriesSet().getSeries();
        this.printExecuteInfo(fileName, printWriter);
        int seriesSize = this.getSeriesSize(series);
        printWriter.println("# Header");
        printWriter.println("xValueList<-vector(\"list\", " + seriesSize + ")");
        printWriter.println("yValueList<-vector(\"list\", " + seriesSize + ")");
        printWriter.println("");
        printWriter.println("# Data");
        int widthPlotArea = baseChart.getPlotArea().getSize().x;
        int index = 1;
        ArrayList<String> color = new ArrayList<String>();
        ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries dataSeries2 = iSeriesArray[n2];
            if (dataSeries2 != null && dataSeries2.isVisible()) {
                ILineSeries lineSeries = (ILineSeries)dataSeries2;
                Color col = lineSeries.getLineColor();
                color.add(this.getColor(col));
                this.printLineData(dataSeries2, widthPlotArea, axisSettings, index++, printWriter);
            }
            ++n2;
        }
        printWriter.println("");
        printWriter.println("#  Footer");
        StringBuilder list = new StringBuilder("colorList<-c(");
        int length = color.size();
        int color_count = 0;
        for (String col : color) {
            list.append("\"");
            list.append(col);
            list.append("\"");
            if (color_count == length - 1) continue;
            list.append(",");
            ++color_count;
        }
        list.append(")");
        printWriter.println(list);
        printWriter.println("");
        printWriter.println("plot(");
        printWriter.println("\txValueList[[1]], yValueList[[1]],");
        printWriter.println("\txlim=c(range(xValueList)[1], range(xValueList)[2]),");
        printWriter.println("\tylim=c(range(yValueList)[1], range(yValueList)[2]),");
        printWriter.println("\ttype='s',");
        printWriter.println("\tcol=colorList[1],");
        printWriter.println("\tylab='" + axisSettingsY.getLabel() + "',");
        printWriter.println("\txlab='" + axisSettingsX.getLabel() + "'");
        printWriter.println(")");
        printWriter.println("");
        if (seriesSize > 1) {
            printWriter.println("for(i in 2:" + seriesSize + "){");
            printWriter.println("\tlines(xValueList[[i]], yValueList[[i]], type='s', col=colorList[i])");
            printWriter.println("}");
            printWriter.println("");
        }
        int size = seriesSize;
        printWriter.println("legend('topleft',");
        printWriter.println("\t\tc(");
        int k = 0;
        ISeries[] iSeriesArray2 = series;
        int n3 = series.length;
        int n4 = 0;
        while (n4 < n3) {
            dataSeries = iSeriesArray2[n4];
            if (dataSeries != null && dataSeries.isVisible()) {
                printWriter.print("\t\t\t'Series " + dataSeries.getDescription() + "'");
                if (k < size - 1) {
                    printWriter.print(",");
                }
                printWriter.println();
                ++k;
            }
            ++n4;
        }
        printWriter.println("\t\t),");
        printWriter.println("\t\tcol=c(");
        k = 0;
        iSeriesArray2 = series;
        n3 = series.length;
        n4 = 0;
        while (n4 < n3) {
            dataSeries = iSeriesArray2[n4];
            if (dataSeries != null && dataSeries.isVisible()) {
                printWriter.print("\t\t\tcolorList[" + (k + 1) + "]");
                if (k < size - 1) {
                    printWriter.print(",");
                }
                printWriter.println();
                ++k;
            }
            ++n4;
        }
        printWriter.println("\t\t),");
        printWriter.println("\t\tlwd=2");
        printWriter.println("\t)");
        printWriter.println("");
    }

    private void printExecuteInfo(String fileName, PrintWriter printWriter) {
        printWriter.println("#-----------------------------------");
        printWriter.println("# source('" + fileName + "')");
        printWriter.println("#-----------------------------------");
        printWriter.println("");
    }

    private int getSeriesSize(ISeries<?>[] series) {
        int counter = 0;
        ISeries<?>[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries<?> dataSeries = iSeriesArray[n2];
            if (dataSeries != null && dataSeries.isVisible()) {
                ++counter;
            }
            ++n2;
        }
        return counter;
    }
}

