/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IProcess;

public class LaunchProcessDictionary {
    private static LaunchProcessDictionary instance;
    private Map<String, Map<String, IProcess>> processDictionary = new HashMap<String, Map<String, IProcess>>();

    private LaunchProcessDictionary() {
    }

    public static LaunchProcessDictionary getInstance() {
        if (instance == null) {
            instance = new LaunchProcessDictionary();
        }
        return instance;
    }

    public void addProcessToDictionary(String launchName, String procName, IProcess process) {
        if (!this.processDictionary.containsKey(launchName)) {
            HashMap<String, IProcess> processMap = new HashMap<String, IProcess>();
            processMap.put(procName, process);
            this.processDictionary.put(launchName, processMap);
            return;
        }
        Map<String, IProcess> processMap = this.processDictionary.get(launchName);
        processMap.put(procName, process);
        this.processDictionary.put(launchName, processMap);
    }

    public IProcess getProcessFromDictionary(String launchName, String procName) {
        if (!this.processDictionary.containsKey(launchName)) {
            return null;
        }
        return this.processDictionary.get(launchName).get(procName);
    }

    public void killAllProcessesInLaunch(String launchName) {
        if (!this.processDictionary.containsKey(launchName)) {
            return;
        }
        for (IProcess process : this.processDictionary.get(launchName).values()) {
            try {
                process.terminate();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
    }
}

