/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf;

import com.espressif.idf.debug.gdbjtag.openocd.Activator;
import com.espressif.idf.debug.gdbjtag.openocd.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.util.StringUtil;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.IMIBackend2;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.dsf.GnuMcuProcesses_7_2_1;
import org.osgi.framework.BundleContext;

public class GdbBackend
extends AbstractDsfService
implements IGDBBackend,
IMIBackend2 {
    private final ILaunchConfiguration fLaunchConfiguration;
    private IPath fProgramPath;
    private IPath fGDBWorkingDirectory;
    private String fGDBInitFile;
    private List<String> fSharedLibPaths;
    private String fProgramArguments;
    private Properties fEnvVariables;
    private SessionType fSessionType;
    private Boolean fAttach;
    private IMIBackend.State fBackendState = IMIBackend.State.NOT_INITIALIZED;
    private final String fBackendId = "gdb[" + Integer.toString(fgInstanceCounter++) + "]";
    private static int fgInstanceCounter = 0;
    private MonitorJob fMonitorJob;
    private Process fProcess;
    private int fGDBExitValue;
    private int fGDBLaunchTimeout = 30;
    private MonitorInterruptJob fInterruptFailedJob;

    public GdbBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session);
        this.fLaunchConfiguration = lc;
        try {
            ICProject cproject = LaunchUtils.getCProject((ILaunchConfiguration)lc);
            this.fProgramPath = LaunchUtils.verifyProgramPath((ILaunchConfiguration)lc, (ICProject)cproject);
        }
        catch (CoreException e) {
            this.fProgramPath = new Path("");
        }
    }

    public void initialize(final RequestMonitor requestMonitor) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuGdbBackend.initialize()");
        }
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GdbBackend.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        final Sequence.Step[] initializeSteps = new Sequence.Step[]{new GDBProcessStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new MonitorJobStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new RegisterStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    public void shutdown(final RequestMonitor requestMonitor) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuGdbBackend.shutdown()");
        }
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new RegisterStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new MonitorJobStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new GDBProcessStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence shutdownSequence = new Sequence(this.getExecutor(), new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                GdbBackend.super.shutdown(requestMonitor);
            }
        }){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)shutdownSequence);
    }

    protected IPath getGDBPath() {
        return LaunchUtils.getGDBPath((ILaunchConfiguration)this.fLaunchConfiguration);
    }

    @Deprecated
    protected String getGDBCommandLine() {
        String[] cmdArray = this.getGDBCommandLineArray();
        return StringUtil.join((String[])cmdArray, (String)" ");
    }

    protected String[] getGDBCommandLineArray() {
        String[] commandLineArray = Configuration.getGdbClientCommandLineArray(this.fLaunchConfiguration);
        return commandLineArray;
    }

    public String getGDBInitFile() throws CoreException {
        if (this.fGDBInitFile == null) {
            String defaultGdbInit = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbInit", ".gdbinit", null);
            this.fGDBInitFile = this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", defaultGdbInit);
        }
        return this.fGDBInitFile;
    }

    public IPath getGDBWorkingDirectory() throws CoreException {
        if (this.fGDBWorkingDirectory == null) {
            ICProject cp;
            String expandedLocation;
            Object path = null;
            String location = this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            if (location != null && (expandedLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(location)).length() > 0) {
                path = new Path(expandedLocation);
            }
            if (path != null) {
                if (path.isAbsolute()) {
                    File dir = new File(path.toPortableString());
                    if (!dir.isDirectory()) {
                        path = null;
                    }
                } else {
                    IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    path = res instanceof IContainer && res.exists() ? res.getLocation() : null;
                }
            }
            if (path == null && (cp = LaunchUtils.getCProject((ILaunchConfiguration)this.fLaunchConfiguration)) != null) {
                IProject p = cp.getProject();
                path = p.getLocation();
            }
            this.fGDBWorkingDirectory = path;
        }
        if (this.fGDBWorkingDirectory == null) {
            this.fGDBWorkingDirectory = DebugUtils.getProjectOsPath((ILaunchConfiguration)this.fLaunchConfiguration);
        }
        return this.fGDBWorkingDirectory;
    }

    public String getProgramArguments() throws CoreException {
        if (this.fProgramArguments == null) {
            this.fProgramArguments = this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
            if (this.fProgramArguments != null) {
                this.fProgramArguments = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fProgramArguments);
            }
        }
        return this.fProgramArguments;
    }

    public IPath getProgramPath() {
        return this.fProgramPath;
    }

    public List<String> getSharedLibraryPaths() throws CoreException {
        if (this.fSharedLibPaths == null) {
            this.fSharedLibPaths = this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", new ArrayList(0));
        }
        return this.fSharedLibPaths;
    }

    public Properties getEnvironmentVariables() throws CoreException {
        if (this.fEnvVariables == null) {
            String[] properties;
            this.fEnvVariables = new Properties();
            boolean append = this.fLaunchConfiguration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
            if (append) {
                ILaunchConfigurationWorkingCopy wc = this.fLaunchConfiguration.copy("");
                wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
                properties = DebugPlugin.getDefault().getLaunchManager().getEnvironment((ILaunchConfiguration)wc);
            } else {
                properties = DebugPlugin.getDefault().getLaunchManager().getEnvironment(this.fLaunchConfiguration);
            }
            if (properties == null) {
                properties = new String[]{};
            }
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                int idx = property.indexOf(61);
                if (idx != -1) {
                    String key = property.substring(0, idx);
                    String value = property.substring(idx + 1);
                    this.fEnvVariables.setProperty(key, value);
                } else {
                    this.fEnvVariables.setProperty(property, "");
                }
                ++n2;
            }
        }
        return this.fEnvVariables;
    }

    public boolean getClearEnvironment() throws CoreException {
        return !this.fLaunchConfiguration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
    }

    public boolean getUpdateThreadListOnSuspend() throws CoreException {
        return this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }

    protected Process launchGDBProcess() throws CoreException {
        String command = this.getGDBCommandLine();
        return this.launchGDBProcess(command);
    }

    @Deprecated
    protected Process launchGDBProcess(String commandLine) throws CoreException {
        String unmodifiedCmdLine = StringUtil.join((String[])this.getGDBCommandLineArray(), (String)" ").trim();
        if (!unmodifiedCmdLine.equals(commandLine.trim())) {
            Process proc = DebugUtils.exec((String)commandLine, (String[])LaunchUtils.getLaunchEnvironment((ILaunchConfiguration)this.fLaunchConfiguration));
            return proc;
        }
        return this.launchGDBProcess(this.getGDBCommandLineArray());
    }

    protected Process launchGDBProcess(String[] commandLineArray) throws CoreException {
        File dir = null;
        IPath path = this.getGDBWorkingDirectory();
        if (path != null) {
            dir = new File(path.toOSString());
        }
        Process proc = DebugUtils.exec((String[])commandLineArray, (String[])DebugUtils.getLaunchEnvironment((ILaunchConfiguration)this.fLaunchConfiguration), (File)dir);
        return proc;
    }

    public Process getProcess() {
        return this.fProcess;
    }

    public OutputStream getMIOutputStream() {
        return this.fProcess.getOutputStream();
    }

    public InputStream getMIInputStream() {
        return this.fProcess.getInputStream();
    }

    public InputStream getMIErrorStream() {
        return this.fProcess.getErrorStream();
    }

    public String getId() {
        return this.fBackendId;
    }

    public void interrupt() {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            if (this.getSessionType() == SessionType.REMOTE) {
                gdbSpawner.interrupt();
            } else {
                gdbSpawner.interruptCTRLC();
            }
        }
    }

    public void interruptAndWait(int timeout, RequestMonitor rm) {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            if (this.getSessionType() == SessionType.REMOTE) {
                gdbSpawner.interrupt();
            } else {
                gdbSpawner.interruptCTRLC();
            }
            this.fInterruptFailedJob = new MonitorInterruptJob(timeout, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot interrupt.", null));
            rm.done();
        }
    }

    public void interruptInferiorAndWait(long pid, int timeout, RequestMonitor rm) {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            gdbSpawner.raise((int)pid, gdbSpawner.INT);
            this.fInterruptFailedJob = new MonitorInterruptJob(timeout, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot interrupt.", null));
            rm.done();
        }
    }

    public void destroy() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuGdbBackend.destroy()");
        }
        if (this.getState() == IMIBackend.State.STARTED) {
            this.fProcess.destroy();
        }
    }

    public IMIBackend.State getState() {
        return this.fBackendState;
    }

    public int getExitCode() {
        return this.fGDBExitValue;
    }

    public SessionType getSessionType() {
        if (this.fSessionType == null) {
            this.fSessionType = LaunchUtils.getSessionType((ILaunchConfiguration)this.fLaunchConfiguration);
        }
        return this.fSessionType;
    }

    public boolean getIsAttachSession() {
        if (this.fAttach == null) {
            this.fAttach = LaunchUtils.getIsAttach((ILaunchConfiguration)this.fLaunchConfiguration);
        }
        return this.fAttach;
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
        if (this.fInterruptFailedJob != null) {
            if (this.fInterruptFailedJob.cancel()) {
                this.fInterruptFailedJob.getRequestMonitor().done();
            }
            this.fInterruptFailedJob = null;
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(GnuMcuProcesses_7_2_1.ProcessStateChangedEvent e) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuGdbBackend.eventDispatched() " + String.valueOf(e));
        }
        if (e.getState() == IMIBackend.State.TERMINATED && e.getSessionId().equals(this.getSession().getId()) && this.getState() == IMIBackend.State.STARTED) {
            this.destroy();
        }
    }

    protected class GDBProcessStep
    extends GDBControl.InitializationShutdownStep {
        GDBProcessStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GDBProcessStep.initialise()");
            }
            class GDBLaunchMonitor {
                boolean fLaunched = false;
                boolean fTimedOut = false;

                GDBLaunchMonitor() {
                }
            }
            final GDBLaunchMonitor fGDBLaunchMonitor = new GDBLaunchMonitor();
            final RequestMonitor gdbLaunchRequestMonitor = new RequestMonitor((Executor)GdbBackend.this.getExecutor(), requestMonitor){
                {
                    super($anonymous0, $anonymous1);
                }

                protected void handleCompleted() {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GDBProcessStep.initialise() handleCompleted()");
                    }
                    if (!fGDBLaunchMonitor.fTimedOut) {
                        fGDBLaunchMonitor.fLaunched = true;
                        if (!this.isSuccess()) {
                            requestMonitor.setStatus(this.getStatus());
                        }
                        requestMonitor.done();
                    }
                }
            };
            final Job startGdbJob = new Job("Start GDB Process Job"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GDBProcessStep.initialise() Job run()");
                    }
                    if (gdbLaunchRequestMonitor.isCanceled()) {
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(8, "org.eclipse.cdt.dsf.gdb", -1, "Canceled starting GDB", null));
                        gdbLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    try {
                        ((GDBProcessStep)GDBProcessStep.this).GdbBackend.this.fProcess = GdbBackend.this.launchGDBProcess();
                        GdbBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                ((GDBProcessStep)(this).GDBProcessStep.this).GdbBackend.this.fBackendState = IMIBackend.State.STARTED;
                            }
                        });
                    }
                    catch (CoreException e) {
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, e.getMessage(), (Throwable)e));
                        gdbLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    BufferedReader inputReader = null;
                    BufferedReader errorReader = null;
                    boolean success = false;
                    try {
                        String line;
                        inputReader = new BufferedReader(new InputStreamReader(GdbBackend.this.getMIInputStream()));
                        while ((line = inputReader.readLine()) != null) {
                            if (!(line = line.trim()).endsWith("(gdb)")) continue;
                            success = true;
                            break;
                        }
                        if (!success) {
                            errorReader = new BufferedReader(new InputStreamReader(GdbBackend.this.getMIErrorStream()));
                            String errorInfo = errorReader.readLine();
                            if (errorInfo == null) {
                                errorInfo = "GDB prompt not read";
                            }
                            gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, errorInfo, null));
                        }
                    }
                    catch (IOException e) {
                        success = false;
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Error reading GDB output", (Throwable)e));
                    }
                    if (!success) {
                        if (inputReader != null) {
                            try {
                                inputReader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (errorReader != null) {
                            try {
                                errorReader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    gdbLaunchRequestMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            startGdbJob.schedule();
            GdbBackend.this.getExecutor().schedule(new Runnable(){
                {
                }

                @Override
                public void run() {
                    if (!fGDBLaunchMonitor.fLaunched) {
                        fGDBLaunchMonitor.fTimedOut = true;
                        Thread jobThread = startGdbJob.getThread();
                        if (jobThread != null) {
                            jobThread.interrupt();
                        }
                        requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5010, "Timed out trying to launch GDB.", null));
                        requestMonitor.done();
                    }
                }
            }, (long)GdbBackend.this.fGDBLaunchTimeout, TimeUnit.SECONDS);
        }

        protected void shutdown(final RequestMonitor requestMonitor) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GDBProcessStep.shutdown()");
            }
            if (GdbBackend.this.getState() != IMIBackend.State.STARTED) {
                requestMonitor.done();
                return;
            }
            new Job("Terminating GDB process."){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("GDBProcessStep.shutdown() run()");
                        }
                        GdbBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                GdbBackend.this.destroy();
                                if (((GDBProcessStep)(this).GDBProcessStep.this).GdbBackend.this.fMonitorJob.fMonitorExited) {
                                    ((GDBProcessStep)(this).GDBProcessStep.this).GdbBackend.this.fBackendState = IMIBackend.State.TERMINATED;
                                    if (Activator.getInstance().isDebugging()) {
                                        System.out.println("GDBProcessStep.shutdown() run() dispatchEvent(BackendStateChangedEvent, TERMINATED)");
                                    }
                                    GdbBackend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(GdbBackend.this.getSession().getId(), GdbBackend.this.getId(), IMIBackend.State.TERMINATED), GdbBackend.this.getProperties());
                                }
                            }
                        }).get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    int attempts = 0;
                    while (attempts < 10) {
                        try {
                            ((GDBProcessStep)GDBProcessStep.this).GdbBackend.this.fGDBExitValue = ((GDBProcessStep)GDBProcessStep.this).GdbBackend.this.fProcess.exitValue();
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GDBProcessStep.shutdown() run() return");
                            }
                            requestMonitor.done();
                            return Status.OK_STATUS;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++attempts;
                        }
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GDBProcessStep.shutdown() run() REQUEST_FAILED");
                    }
                    requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "GDB terminate failed", null));
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    protected class MonitorInterruptJob
    extends Job {
        private static final int TIMEOUT_DEFAULT_VALUE = 5000;
        private final RequestMonitor fRequestMonitor;

        public MonitorInterruptJob(int timeout, RequestMonitor rm) {
            super("Interrupt monitor job.");
            this.setSystem(true);
            this.fRequestMonitor = rm;
            if (timeout == 0 || timeout <= 0) {
                timeout = 5000;
            }
            this.schedule(timeout);
        }

        protected IStatus run(IProgressMonitor monitor) {
            GdbBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    ((MonitorInterruptJob)MonitorInterruptJob.this).GdbBackend.this.fInterruptFailedJob = null;
                    MonitorInterruptJob.this.fRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Interrupt failed.", null));
                    MonitorInterruptJob.this.fRequestMonitor.done();
                }
            });
            return Status.OK_STATUS;
        }

        public RequestMonitor getRequestMonitor() {
            return this.fRequestMonitor;
        }
    }

    private class MonitorJob
    extends Job {
        boolean fMonitorExited;
        DsfRunnable fMonitorStarted;
        Process fMonProcess;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Process process = this.fMonProcess;
            synchronized (process) {
                GdbBackend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                try {
                    this.fMonProcess.waitFor();
                    GdbBackend.this.fGDBExitValue = this.fMonProcess.exitValue();
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("MonitorJob.run() exitValue() " + GdbBackend.this.fGDBExitValue);
                    }
                    if (GdbBackend.this.fProcess.isAlive() && Activator.getInstance().isDebugging()) {
                        GdbBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                if (Activator.getInstance().isDebugging()) {
                                    System.out.println("MonitorJob.run() run() ");
                                }
                                GdbBackend.this.destroy();
                                ((MonitorJob)MonitorJob.this).GdbBackend.this.fBackendState = IMIBackend.State.TERMINATED;
                                if (Activator.getInstance().isDebugging()) {
                                    System.out.println("MonitorJob.run() run() dispatchEvent(BackendStateChangedEvent, TERMINATED)");
                                }
                                GdbBackend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(GdbBackend.this.getSession().getId(), GdbBackend.this.getId(), IMIBackend.State.TERMINATED), GdbBackend.this.getProperties());
                            }
                        });
                    }
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
                this.fMonitorExited = true;
            }
            return Status.OK_STATUS;
        }

        MonitorJob(Process process, DsfRunnable monitorStarted) {
            super("GDB process monitor job.");
            this.fMonitorExited = false;
            this.fMonProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fMonProcess;
            synchronized (process) {
                if (!this.fMonitorExited) {
                    this.getThread().interrupt();
                }
            }
        }
    }

    protected class MonitorJobStep
    extends GDBControl.InitializationShutdownStep {
        MonitorJobStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("MonitorJobStep.initialize()");
            }
            GdbBackend.this.fMonitorJob = new MonitorJob(GdbBackend.this.fProcess, new DsfRunnable(){

                public void run() {
                    requestMonitor.done();
                }
            });
            GdbBackend.this.fMonitorJob.schedule();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("MonitorJobStep.shutdown()");
            }
            if (GdbBackend.this.fMonitorJob != null) {
                GdbBackend.this.fMonitorJob.kill();
            }
            requestMonitor.done();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("MonitorJobStep.shutdown() done");
            }
        }
    }

    protected class RegisterStep
    extends GDBControl.InitializationShutdownStep {
        RegisterStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor requestMonitor) {
            GdbBackend.this.register(new String[]{IMIBackend.class.getName(), IMIBackend2.class.getName(), IGDBBackend.class.getName()}, new Hashtable());
            GdbBackend.this.getSession().addServiceEventListener((Object)GdbBackend.this, null);
            GdbBackend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(GdbBackend.this.getSession().getId(), GdbBackend.this.getId(), IMIBackend.State.STARTED), GdbBackend.this.getProperties());
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GdbBackend.this.unregister();
            GdbBackend.this.getSession().removeServiceEventListener((Object)GdbBackend.this);
            requestMonitor.done();
        }
    }
}

