/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.menu.bitmap;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.export.core.AbstractSeriesExportHandler;
import org.eclipse.swtchart.export.core.BitmapExportSettingsDialog;
import org.eclipse.swtchart.export.core.ISeriesExportConverter;
import org.eclipse.swtchart.extensions.clipboard.ImageSupplier;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;

public abstract class AbstractBitmapExportHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    private String name;
    private String title;
    private String[] filterExtensions;
    private int format;

    public AbstractBitmapExportHandler(String name, String title, String[] filterExtensions, int format) {
        this.name = name;
        this.title = title;
        this.filterExtensions = filterExtensions;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public Image getIcon() {
        return ResourceSupport.getImage((String)"bitmap.gif");
    }

    public void execute(Shell shell, ScrollableChart scrollableChart) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText(this.name);
        fileDialog.setFilterExtensions(this.filterExtensions);
        fileDialog.setFileName(scrollableChart.getFileName());
        String fileName = fileDialog.open();
        if (fileName != null) {
            BitmapExportSettingsDialog bitmapSettingsDialog = new BitmapExportSettingsDialog(fileDialog.getParent());
            bitmapSettingsDialog.create();
            if (bitmapSettingsDialog.open() == 0) {
                BaseChart baseChart = scrollableChart.getBaseChart();
                if (bitmapSettingsDialog.isCustomSize()) {
                    int width = bitmapSettingsDialog.getCustomWidth();
                    int height = bitmapSettingsDialog.getCustomHeight();
                    this.exportCustomSize(baseChart, fileName, width, height);
                } else {
                    this.exportNormal(baseChart, fileName);
                }
            }
        }
    }

    private void exportNormal(BaseChart baseChart, String fileName) {
        ImageSupplier imageSupplier = new ImageSupplier();
        ImageData imageData = imageSupplier.getImageData(baseChart);
        imageSupplier.saveImage(imageData, fileName, this.format);
    }

    private void exportCustomSize(final BaseChart baseChart, String fileName, final int width, final int height) {
        Composite parent = baseChart.getParent();
        Rectangle bounds = baseChart.getBounds();
        Display display = Display.getDefault();
        final Shell imageShell = new Shell(display);
        Rectangle imageBounds = imageShell.computeTrim(0, 0, width, height);
        imageShell.setSize(imageBounds.width, imageBounds.height);
        imageShell.setLocation(0, 0);
        imageShell.setBackground(Display.getDefault().getSystemColor(1));
        imageShell.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                baseChart.setParent((Composite)imageShell);
                baseChart.setBounds(0, 0, width, height);
                baseChart.updateLayout();
            }
        });
        imageShell.open();
        while (!imageShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
            ImageSupplier imageSupplier = new ImageSupplier();
            ImageData imageData = imageSupplier.getImageData(baseChart);
            imageSupplier.saveImage(imageData, fileName, this.format);
            baseChart.setParent(parent);
            baseChart.setBounds(bounds);
            baseChart.updateLayout();
            imageShell.close();
        }
    }
}

