/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor;

import com.cthing.cmakeed.core.commands.CMakeCommand;
import com.cthing.cmakeed.core.commands.CMakeCommands;
import com.cthing.cmakeed.core.properties.CMakeProperties;
import com.cthing.cmakeed.core.properties.CMakeProperty;
import com.cthing.cmakeed.core.reservedwords.CMakeReservedWord;
import com.cthing.cmakeed.core.reservedwords.CMakeReservedWords;
import com.cthing.cmakeed.core.uservariables.CMakeUserVariable;
import com.cthing.cmakeed.core.uservariables.CMakeUserVariables;
import com.cthing.cmakeed.core.utils.StringUtils;
import com.cthing.cmakeed.core.variables.CMakeVariable;
import com.cthing.cmakeed.core.variables.CMakeVariables;
import com.cthing.cmakeed.ui.CMakeEditorPlugin;
import com.cthing.cmakeed.ui.editor.CMakeEditorUI;
import com.cthing.cmakeed.ui.editor.CMakeNameDetector;
import com.cthing.cmakeed.ui.editor.EditorUtils;
import com.cthing.cmakeed.ui.editor.rules.CMakeUserVariableRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

public class CMakeContentAssistantProcessor
extends TemplateCompletionProcessor
implements IContentAssistProcessor,
ITextHover {
    private final CMakeNameDetector detector = new CMakeNameDetector();
    private static final String TEMPLATE_IMAGE = "$nl$/icons/CMakeTemplate.png";
    private static final String COMMAND_IMAGE = "$nl$/icons/CMakeCommand.png";
    private static final String PROPERTY_IMAGE = "$nl$/icons/CMakeProperty.png";
    private static final String VARIABLE_IMAGE = "$nl$/icons/CMakeVariable.png";
    private static final String RESERVED_WORD_IMAGE = "$nl$/icons/CMakeReservedWord.png";

    protected Template[] getTemplates(String contextTypeId) {
        return CMakeEditorUI.getDefault().getTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return CMakeEditorUI.getDefault().getContextTypeRegistry().getContextType("com.cthing.cmakeed.ui.editor.cmake");
    }

    protected Image getImage(Template template) {
        ImageRegistry registry = CMakeEditorUI.getDefault().getImageRegistry();
        Image image = registry.get(TEMPLATE_IMAGE);
        if (image == null) {
            ImageDescriptor desc = CMakeEditorUI.imageDescriptorFromPlugin("com.cthing.cmakeed.ui", TEMPLATE_IMAGE);
            registry.put(TEMPLATE_IMAGE, desc);
            image = registry.get(TEMPLATE_IMAGE);
        }
        return image;
    }

    protected Image getCustomImage(String imageType) {
        ImageRegistry registry = CMakeEditorUI.getDefault().getImageRegistry();
        Image image = registry.get(imageType);
        if (image == null) {
            ImageDescriptor desc = CMakeEditorUI.imageDescriptorFromPlugin("com.cthing.cmakeed.ui", imageType);
            registry.put(imageType, desc);
            image = registry.get(imageType);
        }
        return image;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] templateArray;
        IDocument doc = viewer.getDocument();
        String prefix = this.getPrefix(doc, offset);
        List<ICompletionProposal> proposals = this.findPossibleTemplates(prefix, templateArray = super.computeCompletionProposals(viewer, offset));
        if (proposals == null) {
            proposals = new ArrayList<ICompletionProposal>();
        }
        if (!EditorUtils.inArguments(doc, offset)) {
            List<CMakeCommand> commands = this.findPossibleCommands(prefix);
            if (!commands.isEmpty()) {
                boolean isUpperCase = CMakeEditorPlugin.getDefault().getPreferenceStore().getBoolean("upperCaseCommands");
                if (prefix.length() > 0) {
                    Character.isLowerCase(prefix.charAt(0));
                }
                int replacementOffset = offset - prefix.length();
                int replacementLength = prefix.length();
                for (CMakeCommand command : commands) {
                    String[] usages;
                    String name = isUpperCase ? command.getName().toUpperCase() : command.getName().toLowerCase();
                    String desc = command.getDescription();
                    String[] stringArray = usages = command.getUsages();
                    int n = usages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String usage = stringArray[n2];
                        ContextInformation contextInfo = new ContextInformation("Command::" + name, usage);
                        String replacementString = name + "(";
                        int cursorPosition = name.length() + 1;
                        Image image = this.getCustomImage(COMMAND_IMAGE);
                        String displayString = name + usage;
                        String additionalProposalInfo = desc;
                        proposals.add((ICompletionProposal)new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, (IContextInformation)contextInfo, additionalProposalInfo));
                        ++n2;
                    }
                }
            }
        } else {
            List<ICompletionProposal> uvarProposals;
            List<ICompletionProposal> resProposals;
            List<ICompletionProposal> varProposals;
            proposals = new ArrayList<ICompletionProposal>();
            List<ICompletionProposal> propProposals = this.computePropertyCompletionProposals(viewer, offset);
            if (propProposals != null) {
                proposals.addAll(propProposals);
            }
            if ((varProposals = this.computeCMakeVariableCompletionProposals(viewer, offset)) != null) {
                proposals.addAll(varProposals);
            }
            if ((resProposals = this.computeReservedWordCompletionProposals(viewer, offset)) != null) {
                proposals.addAll(resProposals);
            }
            if ((uvarProposals = this.computeUserVariableCompletionProposals(viewer, offset)) != null) {
                proposals.addAll(uvarProposals);
            }
        }
        return proposals.size() == 0 ? null : proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public List<ICompletionProposal> computeCMakeVariableCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        ArrayList<CompletionProposal> proposals = null;
        if (EditorUtils.inArguments(doc, offset)) {
            String prefix = this.getPrefix(doc, offset);
            List<CMakeVariable> variables = this.findPossibleCMakeVariables(prefix);
            if (!StringUtils.isBlank((String)prefix) && !variables.isEmpty()) {
                boolean isLowercase = Character.isLowerCase(prefix.charAt(0));
                int replacementOffset = offset - prefix.length();
                int replacementLength = prefix.length();
                proposals = new ArrayList<CompletionProposal>();
                for (CMakeVariable variable : variables) {
                    String name = isLowercase ? variable.getName().toUpperCase() : variable.getName();
                    String desc = variable.getDescription();
                    ContextInformation contextInfo = new ContextInformation("CMakeVariable::" + name, name);
                    proposals.add(new CompletionProposal(name, replacementOffset, replacementLength, name.length(), this.getCustomImage(VARIABLE_IMAGE), name, (IContextInformation)contextInfo, desc));
                }
            }
        }
        return proposals;
    }

    private List<CMakeVariable> findPossibleCMakeVariables(String prefix) {
        ArrayList<CMakeVariable> possibles = new ArrayList<CMakeVariable>();
        Collection cmakeVariables = CMakeVariables.getCommands();
        String upperPrefix = prefix.toUpperCase();
        for (CMakeVariable cmakeVariable : cmakeVariables) {
            String name = cmakeVariable.getName();
            if (name.startsWith(upperPrefix)) {
                possibles.add(cmakeVariable);
                continue;
            }
            if (!possibles.isEmpty()) break;
        }
        return possibles;
    }

    public List<ICompletionProposal> computeUserVariableCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        ArrayList<CompletionProposal> proposals = null;
        if (EditorUtils.inArguments(doc, offset)) {
            String prefix = this.getPrefix(doc, offset);
            List<CMakeUserVariable> variables = this.findPossibleUserVariables(prefix, doc);
            if (!StringUtils.isBlank((String)prefix) && !variables.isEmpty()) {
                int replacementOffset = offset - prefix.length();
                int replacementLength = prefix.length();
                proposals = new ArrayList<CompletionProposal>();
                for (CMakeUserVariable variable : variables) {
                    String name = variable.getName();
                    ContextInformation contextInfo = new ContextInformation("CMakeUserVariable::" + name, name);
                    proposals.add(new CompletionProposal(name, replacementOffset, replacementLength, name.length(), this.getCustomImage(VARIABLE_IMAGE), name, (IContextInformation)contextInfo, null));
                }
            }
        }
        return proposals;
    }

    private List<CMakeUserVariable> findPossibleUserVariables(String prefix, IDocument doc) {
        ArrayList<CMakeUserVariable> possibles = new ArrayList<CMakeUserVariable>();
        CMakeUserVariables documentUserVariables = CMakeUserVariableRule.userVariableMap.get(doc);
        Collection userVariables = documentUserVariables.getUserVariables();
        if (prefix.length() == 0) {
            possibles.addAll(userVariables);
            return possibles;
        }
        for (CMakeUserVariable userVariable : userVariables) {
            String name = userVariable.getName();
            if (!name.startsWith(prefix)) continue;
            possibles.add(userVariable);
        }
        return possibles;
    }

    public List<ICompletionProposal> computeReservedWordCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        ArrayList<CompletionProposal> proposals = null;
        if (EditorUtils.inArguments(doc, offset)) {
            String prefix = this.getPrefix(doc, offset);
            List<CMakeReservedWord> reservedWords = this.findPossibleReservedWords(prefix);
            if (!StringUtils.isBlank((String)prefix) && !reservedWords.isEmpty()) {
                boolean isLowercase = Character.isLowerCase(prefix.charAt(0));
                int replacementOffset = offset - prefix.length();
                int replacementLength = prefix.length();
                proposals = new ArrayList<CompletionProposal>();
                for (CMakeReservedWord variable : reservedWords) {
                    String name = isLowercase ? variable.getName().toUpperCase() : variable.getName();
                    ContextInformation contextInfo = new ContextInformation("ReservedWord::" + name, name);
                    proposals.add(new CompletionProposal(name, replacementOffset, replacementLength, name.length(), this.getCustomImage(RESERVED_WORD_IMAGE), name, (IContextInformation)contextInfo, name));
                }
            }
        }
        return proposals;
    }

    private List<CMakeReservedWord> findPossibleReservedWords(String prefix) {
        ArrayList<CMakeReservedWord> possibles = new ArrayList<CMakeReservedWord>();
        Collection commands = CMakeReservedWords.getCommands();
        String lowerPrefix = prefix.toUpperCase();
        for (CMakeReservedWord command : commands) {
            String name = command.getName();
            if (name.startsWith(lowerPrefix)) {
                possibles.add(command);
                continue;
            }
            if (!possibles.isEmpty()) break;
        }
        return possibles;
    }

    public List<ICompletionProposal> computePropertyCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        ArrayList<CompletionProposal> proposals = null;
        if (EditorUtils.inArguments(doc, offset)) {
            String prefix = this.getPrefix(doc, offset);
            List<CMakeProperty> properties = this.findPossibleProperties(prefix);
            if (!StringUtils.isBlank((String)prefix) && !properties.isEmpty()) {
                boolean isLowercase = Character.isLowerCase(prefix.charAt(0));
                int replacementOffset = offset - prefix.length();
                int replacementLength = prefix.length();
                proposals = new ArrayList<CompletionProposal>();
                for (CMakeProperty property : properties) {
                    String name = isLowercase ? property.getName().toUpperCase() : property.getName();
                    String desc = property.getDescription();
                    ContextInformation contextInfo = new ContextInformation("CMakeProperty::" + name, name);
                    proposals.add(new CompletionProposal(name, replacementOffset, replacementLength, name.length(), this.getCustomImage(PROPERTY_IMAGE), name, (IContextInformation)contextInfo, desc));
                }
            }
        }
        return proposals;
    }

    private List<CMakeProperty> findPossibleProperties(String prefix) {
        ArrayList<CMakeProperty> possibles = new ArrayList<CMakeProperty>();
        Collection commands = CMakeProperties.getCommands();
        String lowerPrefix = prefix.toUpperCase();
        for (CMakeProperty command : commands) {
            if (command.isDeprecated()) continue;
            String name = command.getName();
            if (name.startsWith(lowerPrefix)) {
                possibles.add(command);
                continue;
            }
            if (!possibles.isEmpty()) break;
        }
        return possibles;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new Validator();
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'('};
    }

    private String getPrefix(IDocument doc, int offset) {
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                if (!this.detector.isWordPart(c)) {
                    return doc.get(n + 1, offset - n - 1);
                }
                if (n == 0) {
                    return doc.get(n, offset - n);
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError((Object)this, e);
        }
        return "";
    }

    private List<ICompletionProposal> findPossibleTemplates(String prefix, ICompletionProposal[] templates) {
        ArrayList<ICompletionProposal> possibles = new ArrayList<ICompletionProposal>();
        if (templates.length > 0) {
            int i = 0;
            while (i < templates.length) {
                if (templates[i].getDisplayString().startsWith(prefix)) {
                    possibles.add(templates[i]);
                }
                ++i;
            }
        }
        return possibles.size() == 0 ? null : possibles;
    }

    private List<CMakeCommand> findPossibleCommands(String prefix) {
        ArrayList<CMakeCommand> possibles = new ArrayList<CMakeCommand>();
        Collection commands = CMakeCommands.getCommands();
        String lowerPrefix = prefix.toLowerCase();
        for (CMakeCommand command : commands) {
            if (command.isDeprecated()) continue;
            String name = command.getName();
            if (name.startsWith(lowerPrefix)) {
                possibles.add(command);
                continue;
            }
            if (!possibles.isEmpty()) break;
        }
        return possibles;
    }

    public String getErrorMessage() {
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IDocument doc = textViewer.getDocument();
        String description = null;
        if (hoverRegion != null) {
            try {
                String word = doc.get(hoverRegion.getOffset(), hoverRegion.getLength());
                CMakeCommand command = CMakeCommands.getCommand((String)word);
                if (command != null) {
                    description = command.getDescription();
                }
            }
            catch (BadLocationException e) {
                CMakeEditorPlugin.logError((Object)this, e);
            }
        }
        return description;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        ITypedRegion region = null;
        try {
            region = textViewer.getDocument().getPartition(offset);
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError((Object)this, e);
        }
        return region;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;
        protected boolean isCommand = false;
        protected ITextViewer viewer;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            if (!this.isCommand) {
                return false;
            }
            try {
                if (this.viewer.getDocument().getChar(offset - 1) != ')') {
                    return true;
                }
            }
            catch (BadLocationException e) {
                CMakeEditorPlugin.logError(EditorUtils.class, e);
            }
            catch (Exception e) {
                CMakeEditorPlugin.logError(null, e);
            }
            return false;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
            if (info.getContextDisplayString().startsWith("Command::")) {
                this.isCommand = true;
            }
            this.viewer = viewer;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

