/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.launch.serial.core;

import com.espressif.idf.core.util.LaunchUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.launch.CoreBuildGenericLaunchConfigProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public class IDFCoreLaunchConfigProvider
extends CoreBuildGenericLaunchConfigProvider {
    private Map<IProject, Map<String, ILaunchConfiguration>> configs = new HashMap<IProject, Map<String, ILaunchConfiguration>>();

    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project == null) {
            return null;
        }
        String targetConfig = descriptor.getName();
        Map projectConfigs = this.configs.computeIfAbsent(project, key -> new HashMap());
        ILaunchConfiguration configuration = (ILaunchConfiguration)projectConfigs.get(targetConfig);
        configuration = configuration == null ? new LaunchUtil(DebugPlugin.getDefault().getLaunchManager()).findAppropriateLaunchConfig(descriptor, "com.espressif.idf.launch.serial.launchConfigurationType") : configuration;
        configuration = configuration == null ? this.createLaunchConfiguration(descriptor, target) : configuration;
        projectConfigs.put(configuration.getName(), configuration);
        return configuration;
    }

    protected void populateLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        super.populateLaunchConfiguration(descriptor, target, workingCopy);
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        workingCopy.setMappedResources(new IResource[]{project});
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        workingCopy.doSave();
    }

    public boolean launchConfigurationAdded(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getMappedResources() == null) {
            return false;
        }
        IProject project = configuration.getMappedResources()[0].getProject();
        if (project != null && !project.isOpen()) {
            return true;
        }
        if (configuration.exists()) {
            this.configs.computeIfAbsent(project, key -> new HashMap()).put(configuration.getName(), configuration);
        }
        return this.ownsLaunchConfiguration(configuration);
    }

    public boolean launchConfigurationChanged(ILaunchConfiguration configuration) throws CoreException {
        return false;
    }

    public void launchDescriptorRemoved(ILaunchDescriptor descriptor) throws CoreException {
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project == null) {
            return;
        }
        Map<String, ILaunchConfiguration> projectConfigs = this.configs.get(project);
        if (projectConfigs != null) {
            projectConfigs.remove(descriptor.getName());
        }
    }

    public void launchTargetRemoved(ILaunchTarget target) throws CoreException {
    }
}

