/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.wizard;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.ClangFormatFileHandler;
import com.espressif.idf.core.util.ClangdConfigFileHandler;
import com.espressif.idf.core.util.ConsoleManager;
import com.espressif.idf.core.util.IdfCommandExecutor;
import com.espressif.idf.core.util.LaunchUtil;
import com.espressif.idf.ui.UIPlugin;
import com.espressif.idf.ui.handlers.EclipseHandler;
import com.espressif.idf.ui.handlers.NewProjectHandlerUtil;
import com.espressif.idf.ui.templates.IDFProjectGenerator;
import com.espressif.idf.ui.templates.ITemplateNode;
import com.espressif.idf.ui.templates.NewProjectCreationWizardPage;
import com.espressif.idf.ui.templates.TemplatesManager;
import com.espressif.idf.ui.wizard.Messages;
import java.io.File;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.ui.NewLaunchConfigWizard;
import org.eclipse.launchbar.ui.NewLaunchConfigWizardDialog;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigEditPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tools.templates.core.IGenerator;
import org.eclipse.tools.templates.ui.TemplateWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class NewIDFProjectWizard
extends TemplateWizard {
    private static final String NEW_LAUNCH_CONFIG_EDIT_PAGE = "NewLaunchConfigEditPage";
    public static final String TARGET_SWITCH_JOB = "TARGET SWITCH JOB";
    private NewProjectCreationWizardPage projectCreationWizardPage;
    private IProject project;
    private MessageConsole console;

    public NewIDFProjectWizard() {
        IDialogSettings workbenchSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("BasicNewProjectResourceWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("BasicNewProjectResourceWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        if (!NewProjectHandlerUtil.installToolsCheck()) {
            return;
        }
        super.addPages();
        this.setWindowTitle(Messages.NewIDFProjectWizard_NewIDFProject);
        TemplatesManager templatesManager = new TemplatesManager();
        ITemplateNode templateRoot = templatesManager.getTemplates();
        this.projectCreationWizardPage = new NewProjectCreationWizardPage(templateRoot, Messages.NewIDFProjectWizard_TemplatesHeader);
        ITemplateNode templateNode = templatesManager.getTemplateNode("hello_world");
        if (templateNode != null) {
            this.projectCreationWizardPage.setInitialTemplateId(templateNode);
        }
        this.addPage((IWizardPage)this.projectCreationWizardPage);
    }

    public boolean performFinish() {
        IWorkbenchPage page;
        IViewPart viewPart;
        boolean performFinish = super.performFinish();
        if (performFinish && (viewPart = (page = EclipseHandler.getActiveWorkbenchWindow().getActivePage()).findView("org.eclipse.ui.navigator.ProjectExplorer")) != null) {
            ISelectionProvider selProvider = viewPart.getSite().getSelectionProvider();
            String projectName = this.projectCreationWizardPage.getProjectName();
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            selProvider.setSelection((ISelection)new StructuredSelection((Object)this.project));
            this.updateClangFiles(this.project);
        }
        String target = this.projectCreationWizardPage.getSelectedTarget();
        this.getShell().addDisposeListener(event -> {
            ILaunchBarManager launchBarManager = UIPlugin.getService(ILaunchBarManager.class);
            TargetSwitchJob targetSwtichJob = new TargetSwitchJob(target);
            targetSwtichJob.schedule();
            try {
                ILaunchDescriptor desc = launchBarManager.getActiveLaunchDescriptor();
                if (new LaunchUtil(DebugPlugin.getDefault().getLaunchManager()).findAppropriateLaunchConfig(desc, "com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationType") == null) {
                    launchBarManager.getActiveLaunchConfiguration();
                    this.createDefaultDebugConfig();
                    launchBarManager.setActiveLaunchDescriptor(desc);
                }
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
            }
            if (this.projectCreationWizardPage.isRunIdfReconfigureEnabled()) {
                this.runIdfReconfigureCommandJob(target);
            }
        });
        return performFinish;
    }

    private void runIdfReconfigureCommandJob(final String target) {
        Job job = new Job(Messages.IdfReconfigureJobName){

            protected IStatus run(IProgressMonitor monitor) {
                IdfCommandExecutor executor = new IdfCommandExecutor(target, ConsoleManager.getConsole((String)"CDT Build Console"));
                IStatus status = executor.executeReconfigure(NewIDFProjectWizard.this.project);
                try {
                    IDEWorkbenchPlugin.getPluginWorkspace().getRoot().refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                }
                return status;
            }
        };
        job.schedule();
    }

    private void updateClangFiles(IProject project) {
        try {
            new ClangdConfigFileHandler().update(project);
            new ClangFormatFileHandler(project).update();
        }
        catch (Exception e) {
            Logger.log((Exception)e);
        }
    }

    private void createDefaultDebugConfig() {
        Shell activeShell = Display.getDefault().getActiveShell();
        NewLaunchConfigWizard wizard = new NewLaunchConfigWizard();
        NewLaunchConfigWizardDialog dialog = new NewLaunchConfigWizardDialog(activeShell, (IWizard)wizard);
        dialog.create();
        NewLaunchConfigEditPage editPage = (NewLaunchConfigEditPage)wizard.getPage(NEW_LAUNCH_CONFIG_EDIT_PAGE);
        ILaunchConfigurationType debugLaunchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationType");
        editPage.setLaunchConfigType(debugLaunchConfigType);
        PageChangingEvent pageChangingEvent = new PageChangingEvent((Object)wizard, (Object)wizard.getStartingPage(), (Object)editPage);
        editPage.handlePageChanging(pageChangingEvent);
        wizard.performFinish();
        try {
            String originalName = wizard.getWorkingCopy().getName();
            int configPartIndex = originalName.lastIndexOf("Configuration");
            String debugConfigName = configPartIndex != -1 ? originalName.substring(0, configPartIndex) + "Debug" : originalName;
            wizard.getWorkingCopy().copy(debugConfigName).doSave();
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        wizard.dispose();
    }

    protected IGenerator getGenerator() {
        String manifest = "templates/esp-idf-template/manifest.xml";
        File selectedTemplate = null;
        if (this.projectCreationWizardPage != null && this.projectCreationWizardPage.getSelection() != null) {
            selectedTemplate = this.projectCreationWizardPage.getSelection().getFilePath();
            manifest = null;
        }
        IDFProjectGenerator generator = new IDFProjectGenerator(manifest, selectedTemplate, true, this.projectCreationWizardPage.getSelectedTarget());
        generator.setProjectName(this.projectCreationWizardPage.getProjectName());
        if (!this.projectCreationWizardPage.useDefaults()) {
            generator.setLocationURI(this.projectCreationWizardPage.getLocationURI());
        }
        return generator;
    }

    private class TargetSwitchJob
    extends Job {
        private ILaunchBarManager launchBarManager;
        private String target;

        public TargetSwitchJob(String target) {
            super(NewIDFProjectWizard.TARGET_SWITCH_JOB);
            this.target = target;
            this.launchBarManager = UIPlugin.getService(ILaunchBarManager.class);
        }

        private Job findInternalJob() {
            Job[] jobArray = Job.getJobManager().find(null);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job.getName().equals(InternalDebugCoreMessages.CoreBuildLaunchBarTracker_Job)) {
                    return job;
                }
                ++n2;
            }
            return null;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Job job = this.findInternalJob();
            if (job != null) {
                try {
                    job.join();
                }
                catch (InterruptedException e1) {
                    Logger.log((Exception)e1);
                }
            }
            Display.getDefault().syncExec(() -> {
                ILaunchTarget launchTarget = this.findSuitableTargetForSelectedTargetString();
                try {
                    this.launchBarManager.setActiveLaunchTarget(launchTarget);
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                }
            });
            return Status.OK_STATUS;
        }

        private ILaunchTarget findSuitableTargetForSelectedTargetString() {
            ILaunchTarget[] targets;
            ILaunchTargetManager launchTargetManager = UIPlugin.getService(ILaunchTargetManager.class);
            ILaunchTarget[] iLaunchTargetArray = targets = launchTargetManager.getLaunchTargetsOfType("com.espressif.idf.launch.serial.core.serialFlashTarget");
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchTarget iLaunchTarget = iLaunchTargetArray[n2];
                String idfTarget = iLaunchTarget.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", null);
                if (idfTarget.contentEquals(this.target)) {
                    return iLaunchTarget;
                }
                ++n2;
            }
            return null;
        }
    }
}

