/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.wizard;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.EclipseUtil;
import com.espressif.idf.ui.wizard.Messages;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewComponentWizardPage
extends WizardPage {
    private Text componentName;
    private Composite container;
    private Combo projectCombo;

    protected NewComponentWizardPage(IStructuredSelection selection) {
        super(Messages.NewIdfComponentWizard_Page);
        this.setTitle(Messages.NewIdfComponentWizard_Component_Title);
        this.setDescription(Messages.NewIdfComponentWizard_CompDesc);
        this.setControl((Control)this.componentName);
    }

    public String createIdfComponent() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IDFUtil.getIDFPythonEnvPath());
        commands.add(IDFUtil.getIDFPythonScriptFile().getAbsolutePath());
        commands.add("-C");
        commands.add("components");
        commands.add("create-component");
        commands.add(this.componentName.getText());
        Map envMap = new IDFEnvironmentVariables().getSystemEnvMap();
        return this.runCommand(commands, envMap);
    }

    private String runCommand(List<String> arguments, Map<String, String> env) {
        String exportCmdOp = "";
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IProject selectedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectCombo.getText());
            IPath newPath = selectedProject.getLocation();
            IStatus status = processRunner.runInBackground(arguments, newPath, env);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Status can't be null", null));
            }
            exportCmdOp = status.getMessage();
            Logger.log((String)exportCmdOp);
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
        }
        return exportCmdOp;
    }

    public void createControl(Composite parent) {
        IProject[] projects;
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label label = new Label(this.container, 0);
        label.setText(Messages.NewIdfComponentWizard_Component_name);
        this.componentName = new Text(this.container, 2048);
        this.componentName.setText("");
        this.componentName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewComponentWizardPage.this.setPageComplete(NewComponentWizardPage.this.validatePage());
            }
        });
        GridData gd = new GridData(768);
        this.componentName.setLayoutData((Object)gd);
        Label projectNameLbl = new Label(this.container, 0);
        projectNameLbl.setText(Messages.NewComponentWizardPage_ProjectNameLbl);
        this.projectCombo = new Combo(this.container, 2056);
        Optional<IProject> optProject = Optional.ofNullable(EclipseUtil.getSelectedProjectInExplorer());
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            this.projectCombo.add(project2.getName());
            ++n2;
        }
        optProject.ifPresent(project -> this.projectCombo.setText(project.getName()));
        this.projectCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewComponentWizardPage.this.setPageComplete(NewComponentWizardPage.this.validatePage());
            }
        });
        this.projectCombo.setLayoutData((Object)gd);
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    protected boolean validatePage() {
        if (StringUtil.isEmpty((String)this.projectCombo.getText())) {
            this.setErrorMessage(Messages.NewComponentWizardPage_CantCreateCompErr);
            return false;
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectCombo.getText()).exists()) {
            this.setErrorMessage(Messages.NewComponentWizardPage_ProjectDoesntExistErr);
            return false;
        }
        if (this.componentName.getText().isEmpty()) {
            this.setErrorMessage(Messages.NewIdfComponentWizard_NameCantBeEmptyErr);
            return false;
        }
        if (this.componentName.getText().contains(" ")) {
            this.setErrorMessage(Messages.NewIdfComponentWizard_NameCantIncludeSpaceErr);
            return false;
        }
        if (this.checkIfComponentExists()) {
            this.setErrorMessage(Messages.NewIdfComponentWizard_NameAlreadyExistsErr);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean checkIfComponentExists() {
        return Files.exists(this.getCreatedComponentPath(), new LinkOption[0]);
    }

    public Path getCreatedComponentPath() {
        IProject selectedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectCombo.getText());
        IPath newPath = selectedProject.getLocation().append("components").append(this.componentName.getText());
        return Paths.get(newPath.toString(), new String[0]);
    }
}

