/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing.heaptracing;

import com.espressif.idf.ui.tracing.AddressInfoVO;
import com.espressif.idf.ui.tracing.ConsolidatedCallersVO;
import com.espressif.idf.ui.tracing.ConsolidatedCallersViewContentProvider;
import com.espressif.idf.ui.tracing.DetailsVO;
import com.espressif.idf.ui.tracing.Messages;
import com.espressif.idf.ui.tracing.TracingJsonParser;
import com.espressif.idf.ui.tracing.TracingUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class HeapTracingCallersViewComposite {
    private TracingJsonParser tracingJsonParser;
    private Tree tree;
    private TreeViewer viewer;

    public HeapTracingCallersViewComposite(TracingJsonParser tracingJsonParser) {
        this.tracingJsonParser = tracingJsonParser;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 66306);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.tree = this.viewer.getTree();
        this.tree.addSelectionListener((SelectionListener)new ItemSelectionListener());
        this.createViewerColumns();
        this.viewer.setContentProvider((IContentProvider)new ConsolidatedCallersViewContentProvider());
        if (this.tracingJsonParser.getCallersAddressMap() == null || this.tracingJsonParser.getCallersAddressMap().keySet().size() == 0) {
            return;
        }
        this.createTree();
        this.viewer.getTree().redraw();
        this.viewer.expandAll();
    }

    private void createViewerColumns() {
        TreeViewerColumn colSize = new TreeViewerColumn(this.viewer, 16384);
        colSize.getColumn().setWidth(150);
        colSize.getColumn().setText(Messages.TracingCallersConsolodiatedView_BytesUsed);
        colSize.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        TreeViewerColumn colHitCount = new TreeViewerColumn(this.viewer, 16384);
        colHitCount.getColumn().setWidth(150);
        colHitCount.getColumn().setText(Messages.TracingCallersConsolodiatedView_HitsCount);
        colHitCount.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        TreeViewerColumn colFileName = new TreeViewerColumn(this.viewer, 16384);
        colFileName.getColumn().setWidth(200);
        colFileName.getColumn().setText(Messages.TracingCallerView_ColFileName);
        colFileName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        TreeViewerColumn colFunctionName = new TreeViewerColumn(this.viewer, 16384);
        colFunctionName.getColumn().setWidth(200);
        colFunctionName.getColumn().setText(Messages.TracingCallerView_ColFunctionName);
        colFunctionName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        TreeViewerColumn colLineNumber = new TreeViewerColumn(this.viewer, 0x1000000);
        colLineNumber.getColumn().setWidth(100);
        colLineNumber.getColumn().setText(Messages.TracingCallerView_ColLineNumber);
        colLineNumber.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        TreeViewerColumn colAddress = new TreeViewerColumn(this.viewer, 0x1000000);
        colAddress.getColumn().setText(Messages.TracingCallerView_ColAddress);
        colAddress.getColumn().setWidth(100);
        colAddress.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
    }

    private void createTree() {
        Integer[] ids = new Integer[]{this.tracingJsonParser.getAllocEventId(), this.tracingJsonParser.getFreeEventId()};
        List<DetailsVO> detailsVOs = this.tracingJsonParser.getDetailsVOs(Arrays.asList(ids));
        for (DetailsVO detailsVO : detailsVOs) {
            List callers = detailsVO.getEventsVO().getCallersAddressList().stream().filter(addr -> !addr.equals("0x0")).collect(Collectors.toList());
            Collections.reverse(callers);
            int index = 0;
            String parentForCurrentSet = (String)callers.get(0);
            if (this.tree.getItemCount() == 0) {
                AddressInfoVO addressInfoVO = this.tracingJsonParser.getCallersAddressMap().get(parentForCurrentSet);
                ConsolidatedCallersVO consolidatedCallersVO = new ConsolidatedCallersVO();
                consolidatedCallersVO.setAddressInfoVO(addressInfoVO);
                consolidatedCallersVO.setSizeUsed(0.0);
                TreeItem item = new TreeItem(this.tree, 0);
                item.setData((Object)consolidatedCallersVO);
                this.setTextOnTreeItem(item);
            }
            for (String caller : callers) {
                String prevCaller;
                TreeItem foundParentItem;
                boolean itemExists = false;
                TreeItem[] treeItemArray = this.tree.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    ConsolidatedCallersVO itemCaller = (ConsolidatedCallersVO)item.getData();
                    if (itemCaller.getAddressInfoVO().getAddress().equals(caller) && parentForCurrentSet.equals(caller)) {
                        itemCaller.setSizeUsed(itemCaller.getSizeUsed() + (double)detailsVO.getEventsVO().getSizeOfAllocatedMemoryBlock());
                        itemCaller.setHitCount(itemCaller.getHitCount() + 1);
                        item.setData((Object)itemCaller);
                        this.setTextOnTreeItem(item);
                        itemExists = true;
                        break;
                    }
                    ++n2;
                }
                if (itemExists) {
                    ++index;
                    continue;
                }
                boolean parentItemExists = false;
                if (!itemExists && index - 1 >= 0 && (foundParentItem = this.findItemForCurrentSetOnly(prevCaller = (String)callers.get(index - 1), parentForCurrentSet)) != null) {
                    TreeItem itemForCaller = this.findItem(foundParentItem, caller);
                    if (itemForCaller != null) {
                        currentItemCaller = (ConsolidatedCallersVO)itemForCaller.getData();
                        currentItemCaller.setSizeUsed(currentItemCaller.getSizeUsed() + (double)detailsVO.getEventsVO().getSizeOfAllocatedMemoryBlock());
                        currentItemCaller.setHitCount(currentItemCaller.getHitCount() + 1);
                        itemForCaller.setData((Object)currentItemCaller);
                        this.setTextOnTreeItem(itemForCaller);
                        itemExists = true;
                    } else {
                        currentItemCaller = new ConsolidatedCallersVO();
                        currentItemCaller.setAddressInfoVO(this.tracingJsonParser.getCallersAddressMap().get(caller));
                        currentItemCaller.setSizeUsed(detailsVO.getEventsVO().getSizeOfAllocatedMemoryBlock());
                        currentItemCaller.setHitCount(currentItemCaller.getHitCount() + 1);
                        TreeItem item = new TreeItem(foundParentItem, 0);
                        item.setData((Object)currentItemCaller);
                        this.setTextOnTreeItem(item);
                        parentItemExists = true;
                    }
                }
                if (!parentItemExists && !itemExists) {
                    ConsolidatedCallersVO itemCaller = new ConsolidatedCallersVO();
                    itemCaller.setSizeUsed(detailsVO.getEventsVO().getSizeOfAllocatedMemoryBlock());
                    itemCaller.setAddressInfoVO(this.tracingJsonParser.getCallersAddressMap().get(caller));
                    itemCaller.setHitCount(itemCaller.getHitCount() + 1);
                    TreeItem item = new TreeItem(this.tree, 0);
                    item.setData((Object)itemCaller);
                    this.setTextOnTreeItem(item);
                }
                ++index;
            }
        }
    }

    private void setTextOnTreeItem(TreeItem item) {
        ConsolidatedCallersVO itemCaller = (ConsolidatedCallersVO)item.getData();
        int index = 0;
        item.setText(index++, String.valueOf(itemCaller.getSizeUsed()));
        item.setText(index++, String.valueOf(itemCaller.getHitCount()));
        item.setText(index++, itemCaller.getAddressInfoVO().getFile().getName());
        item.setText(index++, itemCaller.getAddressInfoVO().getFunctionName());
        item.setText(index++, String.valueOf(itemCaller.getAddressInfoVO().getLineNumber()));
        item.setText(index++, itemCaller.getAddressInfoVO().getAddress());
    }

    private TreeItem findItemForCurrentSetOnly(String caller, String parentForCurrentSet) {
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subItem = treeItemArray[n2];
            ConsolidatedCallersVO mainItem = (ConsolidatedCallersVO)subItem.getData();
            if (mainItem.getAddressInfoVO().getAddress().equals(parentForCurrentSet)) {
                if (parentForCurrentSet.equals(caller)) {
                    return subItem;
                }
                return this.findItem(subItem, caller);
            }
            ++n2;
        }
        return null;
    }

    private TreeItem findItem(TreeItem item, String caller) {
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subItem = treeItemArray[n2];
            ConsolidatedCallersVO subCallerItem = (ConsolidatedCallersVO)subItem.getData();
            if (subCallerItem.getAddressInfoVO().getAddress().equals(caller)) {
                return subItem;
            }
            TreeItem itemFound = this.findItem(subItem, caller);
            if (itemFound != null) {
                return itemFound;
            }
            ++n2;
        }
        return null;
    }

    private class ItemSelectionListener
    extends SelectionAdapter {
        private ItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TreeItem[] selection = HeapTracingCallersViewComposite.this.tree.getSelection();
            AddressInfoVO addressInfoVO = (AddressInfoVO)selection[0].getData();
            TracingUtil.launchEditor(addressInfoVO.getFullFilePath());
            TracingUtil.goToLineNumber(addressInfoVO.getLineNumber());
        }
    }
}

