/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.partitiontable.dialog;

import com.espressif.idf.core.build.PartitionTableBean;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.PartitionBeanValidator;
import com.espressif.idf.core.util.PartitionTableDataUtil;
import com.espressif.idf.ui.EclipseUtil;
import com.espressif.idf.ui.partitiontable.dialog.ComboBoxTextCellEditor;
import com.espressif.idf.ui.partitiontable.dialog.Messages;
import com.espressif.idf.ui.partitiontable.dialog.PartitionTableLabelProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;

public class PartitionTableEditorDialog
extends Dialog {
    private Table csvTable;
    private TableViewer tableViewer;
    private final String[] columnNames = new String[]{"Name", "Type", "Sub Type", "Offset", "Size", "Encrypted"};
    private final String FLAGS_VALUE = "encrypted";
    private Action addAction;
    private Action saveAction;
    private Action deleteAction;
    private CellEditor[] cellEditors;
    private ToolBar toolBar;
    private IFile csvFile;
    private Boolean isPageValid;

    public PartitionTableEditorDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
    }

    public void create(IFile csvFile) {
        this.csvFile = csvFile;
        super.create();
        this.getShell().setText(Messages.PartitionTableEditorDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        this.createToolBar(parent);
        this.createTable(parent);
        this.createColumns();
        this.createTableViewer();
        return super.createDialogArea(parent);
    }

    private void createTable(Composite parent) {
        this.csvTable = new Table(parent, 68352);
        this.csvTable.setHeaderVisible(true);
        this.csvTable.setLinesVisible(true);
        this.csvTable.setLayoutData((Object)new GridData(1808));
        this.csvTable.addMouseTrackListener(new MouseTrackListener(){
            Shell errorToolTip;

            public void mouseHover(MouseEvent event) {
                ViewerCell item = PartitionTableEditorDialog.this.tableViewer.getCell(new Point(event.x, event.y));
                if (item != null) {
                    if (this.errorToolTip != null && !this.errorToolTip.isDisposed()) {
                        this.errorToolTip.dispose();
                    }
                    this.errorToolTip = new Shell(PartitionTableEditorDialog.this.getShell(), 16388);
                    this.errorToolTip.setLayout((Layout)new FillLayout());
                    Label label = new Label((Composite)this.errorToolTip, 0);
                    label.setForeground(PartitionTableEditorDialog.this.getShell().getDisplay().getSystemColor(28));
                    label.setBackground(PartitionTableEditorDialog.this.getShell().getDisplay().getSystemColor(29));
                    label.setText(new PartitionBeanValidator().validateBean((PartitionTableBean)item.getElement(), item.getColumnIndex()));
                    Point size = this.errorToolTip.computeSize(-1, -1);
                    Rectangle rect = item.getBounds();
                    Point pt = PartitionTableEditorDialog.this.csvTable.toDisplay(rect.x, rect.y);
                    this.errorToolTip.setBounds(pt.x, pt.y, size.x, size.y);
                    this.errorToolTip.setVisible(true);
                    PartitionTableEditorDialog.this.csvTable.addMouseMoveListener(e -> this.errorToolTip.dispose());
                }
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
            }
        });
    }

    private void createToolBar(Composite parent) {
        this.createAddNewAction();
        this.createDeleteAction();
        this.createSaveAction();
        this.toolBar = new ToolBar(parent, 0x820000);
        ToolBarManager manager = new ToolBarManager(this.toolBar);
        manager.add((IAction)this.addAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.saveAction);
        manager.update(true);
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.csvTable);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List list = (List)inputElement;
                return list.toArray();
            }
        });
        try {
            List list = PartitionTableDataUtil.parseCsv((Path)Paths.get(this.csvFile.getLocationURI()));
            this.tableViewer.setInput((Object)list);
            for (PartitionTableBean bean : list) {
                this.tableViewer.update((Object)bean, null);
            }
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PartitionTableLabelProvider());
        this.tableViewer.setColumnProperties(this.columnNames);
        this.cellEditors = new CellEditor[6];
        this.cellEditors[0] = new TextCellEditor((Composite)this.csvTable);
        this.cellEditors[1] = new ComboBoxTextCellEditor(this.csvTable, PartitionTableDataUtil.getTypeValues(), 2048);
        this.cellEditors[2] = new ComboBoxTextCellEditor(this.csvTable, PartitionTableDataUtil.getSubTypeValues((String)""), 2048);
        this.cellEditors[3] = this.cellEditors[0];
        this.cellEditors[4] = this.cellEditors[0];
        this.cellEditors[5] = new CheckboxCellEditor((Composite)this.csvTable, 2080);
        this.tableViewer.setCellEditors(this.cellEditors);
        this.tableViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                int index = -1;
                int i = 0;
                while (i < PartitionTableEditorDialog.this.columnNames.length) {
                    if (PartitionTableEditorDialog.this.columnNames[i].equals(property)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                PartitionTableBean bean = null;
                if (element instanceof Item) {
                    TableItem item = (TableItem)element;
                    bean = (PartitionTableBean)item.getData();
                } else {
                    bean = (PartitionTableBean)element;
                }
                switch (index) {
                    case 0: {
                        bean.setName((String)value);
                        break;
                    }
                    case 1: {
                        if (value instanceof String) {
                            bean.setType((String)value);
                        } else {
                            bean.setType(PartitionTableDataUtil.getTypeValues()[(Integer)value]);
                        }
                        ((ComboBoxCellEditor)PartitionTableEditorDialog.this.cellEditors[2]).setItems(PartitionTableDataUtil.getSubTypeValues((String)bean.getType()));
                        PartitionTableEditorDialog.this.tableViewer.refresh();
                        break;
                    }
                    case 2: {
                        PartitionTableEditorDialog.this.tableViewer.refresh();
                        if (value instanceof String) {
                            bean.setSubType((String)value);
                            break;
                        }
                        bean.setSubType(PartitionTableDataUtil.getSubTypeValues((String)bean.getType())[(Integer)value]);
                        break;
                    }
                    case 3: {
                        bean.setOffSet((String)value);
                        break;
                    }
                    case 4: {
                        bean.setSize((String)value);
                        break;
                    }
                    case 5: {
                        bean.setFlag((Boolean)value != false ? "encrypted" : "");
                        break;
                    }
                }
                PartitionTableEditorDialog.this.tableViewer.update((Object)bean, null);
            }

            public Object getValue(Object element, String property) {
                int index = -1;
                int i = 0;
                while (i < PartitionTableEditorDialog.this.columnNames.length) {
                    if (PartitionTableEditorDialog.this.columnNames[i].equals(property)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                PartitionTableBean bean = (PartitionTableBean)element;
                switch (index) {
                    case 0: {
                        return bean.getName();
                    }
                    case 1: {
                        String stringValue = bean.getType();
                        String[] choices = PartitionTableDataUtil.getTypeValues();
                        int i2 = choices.length - 1;
                        while (!stringValue.equals(choices[i2]) && i2 > 0) {
                            --i2;
                        }
                        if (i2 == 0 && !stringValue.equals(choices[i2])) {
                            return stringValue;
                        }
                        return i2;
                    }
                    case 2: {
                        ((ComboBoxCellEditor)PartitionTableEditorDialog.this.cellEditors[2]).setItems(PartitionTableDataUtil.getSubTypeValues((String)bean.getType()));
                        String stringValue = bean.getSubType();
                        String[] choices = PartitionTableDataUtil.getSubTypeValues((String)bean.getType());
                        int i3 = choices.length - 1;
                        while (!stringValue.equals(choices[i3]) && i3 > 0) {
                            --i3;
                        }
                        if (i3 == 0 && !stringValue.equals(choices[i3])) {
                            return stringValue;
                        }
                        return i3;
                    }
                    case 3: {
                        return bean.getOffSet();
                    }
                    case 4: {
                        return bean.getSize();
                    }
                    case 5: {
                        return bean.getFlag().contentEquals("encrypted");
                    }
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
    }

    private void createColumns() {
        TableColumn nameColumn = new TableColumn(this.csvTable, 0);
        nameColumn.setText(this.columnNames[0]);
        TableColumn typeColumn = new TableColumn(this.csvTable, 0);
        typeColumn.setText(this.columnNames[1]);
        TableColumn subTypeColumn = new TableColumn(this.csvTable, 0);
        subTypeColumn.setText(this.columnNames[2]);
        TableColumn offSetColumn = new TableColumn(this.csvTable, 0);
        offSetColumn.setText(this.columnNames[3]);
        TableColumn sizeColumn = new TableColumn(this.csvTable, 0);
        sizeColumn.setText(this.columnNames[4]);
        TableColumn encryptedColumn = new TableColumn(this.csvTable, 0);
        encryptedColumn.setText(this.columnNames[5]);
        nameColumn.setWidth(100);
        typeColumn.setWidth(100);
        subTypeColumn.setWidth(100);
        offSetColumn.setWidth(100);
        sizeColumn.setWidth(100);
        encryptedColumn.setWidth(100);
    }

    private void createAddNewAction() {
        this.addAction = new Action(Messages.PartitionTableEditorDialog_AddRowAction){

            public void run() {
                List beansToSave = (List)PartitionTableEditorDialog.this.tableViewer.getInput();
                beansToSave.add(new PartitionTableBean());
                PartitionTableEditorDialog.this.tableViewer.setInput((Object)beansToSave);
                PartitionTableEditorDialog.this.tableViewer.refresh();
                PartitionTableEditorDialog.this.csvTable.select(PartitionTableEditorDialog.this.csvTable.getItemCount() - 1);
            }
        };
    }

    private void createDeleteAction() {
        this.deleteAction = new Action(Messages.PartitionTableEditorDialog_DeleteSelectedAction){

            public void run() {
                List beansToSave = (List)PartitionTableEditorDialog.this.tableViewer.getInput();
                boolean confirmDelete = MessageDialog.openConfirm((Shell)PartitionTableEditorDialog.this.getShell(), (String)Messages.PartitionTableEditorDialog_DeleteConfirmationAction, (String)Messages.PartitionTableEditorDialog_ConfirmDeleteMsg);
                if (!confirmDelete) {
                    return;
                }
                beansToSave.remove(PartitionTableEditorDialog.this.tableViewer.getElementAt(PartitionTableEditorDialog.this.csvTable.getSelectionIndex()));
                PartitionTableEditorDialog.this.tableViewer.setInput((Object)beansToSave);
                PartitionTableEditorDialog.this.tableViewer.refresh();
                super.run();
            }
        };
    }

    private void createSaveAction() {
        this.saveAction = new Action(Messages.PartitionTableEditorDialog_SaveAction){

            public void run() {
                List beansToSave = (List)PartitionTableEditorDialog.this.tableViewer.getInput();
                PartitionTableEditorDialog.this.isPageValid = PartitionTableEditorDialog.this.validateBeansBeforeSaving(beansToSave);
                if (!PartitionTableEditorDialog.this.isPageValid.booleanValue()) {
                    return;
                }
                PartitionTableDataUtil.saveCsv((IFile)PartitionTableEditorDialog.this.csvFile, (List)beansToSave);
                MessageDialog.openInformation((Shell)PartitionTableEditorDialog.this.getShell(), (String)Messages.PartitionTableEditorDialog_SaveInfoTitle, (String)Messages.PartitionTableEditorDialog_SaveInfoMsg);
                try {
                    EclipseUtil.getSelectedProjectInExplorer().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                }
            }
        };
    }

    private boolean validateBeansBeforeSaving(List<PartitionTableBean> beans) {
        String errorMsg = "";
        for (PartitionTableBean bean : beans) {
            int i = 0;
            while (i < this.columnNames.length) {
                errorMsg = new PartitionBeanValidator().validateBean(bean, i);
                if (!errorMsg.isBlank()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.PartitionTableEditorDialog_SaveErrorTitle, (String)Messages.PartitionTableEditorDialog_SaveErrorMsg);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.PartitionTableEditorSaveAndQuitButtonLable, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.saveAction.run();
        if (this.isPageValid.booleanValue()) {
            super.okPressed();
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

