/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.nvs.dialog;

import java.util.stream.Stream;

public enum NvsColumn {
    KEY("Key", 100),
    TYPE("Type", 100),
    ENCODING("Encoding", 100),
    VALUE("Value", 150);

    private final String displayName;
    private final int defaultWidth;

    private NvsColumn(String displayName, int defaultWidth) {
        this.displayName = displayName;
        this.defaultWidth = defaultWidth;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public int getIndex() {
        return this.ordinal();
    }

    public static String[] getColumnProperties() {
        return (String[])Stream.of(NvsColumn.values()).map(NvsColumn::getDisplayName).toArray(String[]::new);
    }

    public static NvsColumn fromIndex(int index) {
        if (index >= 0 && index < NvsColumn.values().length) {
            return NvsColumn.values()[index];
        }
        throw new IndexOutOfBoundsException("Invalid column index: " + index);
    }
}

