/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.kconfig;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class KConfigContentAssistProcessor
implements IContentAssistProcessor {
    private static final String[] MAIN_KEYWORDS = new String[]{"config", "menuconfig", "choice", "endchoice", "menu", "endmenu", "if", "endif", "source", "comment", "mainmenu"};
    private static final String[] TYPES = new String[]{"bool", "tristate", "int", "hex", "string"};
    private static final String[] PROPERTIES = new String[]{"default", "depends", "select", "imply", "range", "help", "prompt", "visible", "optional"};
    private static final String[] VALUES = new String[]{"y", "n", "m"};

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String text = viewer.getDocument().get();
        int lineStart = text.lastIndexOf(10, offset - 1) + 1;
        String lineText = text.substring(lineStart, offset).trim();
        String[] stringArray = MAIN_KEYWORDS;
        int n = MAIN_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (keyword.toLowerCase().startsWith(lineText.toLowerCase())) {
                proposals.add(this.createProposal(keyword, offset - lineText.length(), lineText.length(), keyword));
            }
            ++n2;
        }
        stringArray = TYPES;
        n = TYPES.length;
        n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.toLowerCase().startsWith(lineText.toLowerCase())) {
                proposals.add(this.createProposal(type, offset - lineText.length(), lineText.length(), type));
            }
            ++n2;
        }
        stringArray = PROPERTIES;
        n = PROPERTIES.length;
        n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (property.toLowerCase().startsWith(lineText.toLowerCase())) {
                proposals.add(this.createProposal(property, offset - lineText.length(), lineText.length(), property));
            }
            ++n2;
        }
        stringArray = VALUES;
        n = VALUES.length;
        n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value.toLowerCase().startsWith(lineText.toLowerCase())) {
                proposals.add(this.createProposal(value, offset - lineText.length(), lineText.length(), value));
            }
            ++n2;
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private ICompletionProposal createProposal(String text, int offset, int length, String displayText) {
        return new CompletionProposal(text, offset, length, text.length(), null, displayText, null, null);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{' ', '\t', '\n'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

