/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.installcomponents;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.installcomponents.Messages;
import com.espressif.idf.ui.installcomponents.container.InstallComponentsCompositePage;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class InstallComponentsEditor
extends MultiPageEditorPart {
    public static String EDITOR_ID = "com.espressif.idf.ui.installComponents";
    private IFile componentsJsonFile;
    private IProject project;
    private InstallComponentsCompositePage installComponentsCompositePage;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        FileEditorInput editorInput = (FileEditorInput)this.getEditorInput();
        this.componentsJsonFile = editorInput.getFile();
        this.project = this.componentsJsonFile.getProject();
        this.setPartName(this.project.getName());
        this.installComponentsCompositePage = new InstallComponentsCompositePage(this.componentsJsonFile, this.project);
    }

    protected void createPages() {
        String osString = this.componentsJsonFile.getLocation().toOSString();
        Logger.log((String)("Editor input:" + osString));
        try {
            this.createComponentsInstallPage();
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
    }

    private void createComponentsInstallPage() throws IOException {
        Composite parent = new Composite(this.getContainer(), 0);
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginWidth = 10;
        mainLayout.marginHeight = 10;
        mainLayout.verticalSpacing = 10;
        parent.setLayout((Layout)mainLayout);
        Text searchText = new Text(parent, 2944);
        searchText.setMessage(Messages.InstallComponentsEditor_SearchComponentMsg);
        searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        searchText.addModifyListener(e -> this.installComponentsCompositePage.filterComponents(searchText.getText()));
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setLayout((Layout)new GridLayout());
        scrolledComposite.setAlwaysShowScrollBars(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite subContainer = new Composite((Composite)scrolledComposite, 0);
        GridLayout gridLayout = new GridLayout(4, true);
        subContainer.setLayout((Layout)gridLayout);
        this.installComponentsCompositePage.createControls(subContainer);
        scrolledComposite.setContent((Control)subContainer);
        scrolledComposite.setMinSize(subContainer.computeSize(-1, -1));
        scrolledComposite.addListener(11, event -> {
            int width = scrolledComposite.getClientArea().width;
            scrolledComposite.setMinSize(subContainer.computeSize(width, -1));
        });
        int index = this.addPage((Control)parent);
        this.setPageText(index, "Install Components");
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.installComponentsCompositePage.dispose();
    }
}

