/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.handlers;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.handlers.Messages;
import com.espressif.idf.ui.tools.ManageEspIdfVersionsHandler;
import java.util.Optional;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NewProjectHandlerUtil {
    public static boolean installToolsCheck() {
        String idfPath = IDFUtil.getIDFPath();
        IEnvironmentVariable pathEnv = new IDFEnvironmentVariables().getEnv("PATH");
        String path = Optional.ofNullable(pathEnv).map(o -> o.getValue()).orElse(null);
        IEclipsePreferences scopedPreferenceStore = InstanceScope.INSTANCE.getNode("com.espressif.idf.ui");
        boolean isToolsInstalled = scopedPreferenceStore.getBoolean("INSTALL_TOOLS_FLAG", false);
        if (StringUtil.isEmpty((String)idfPath)) {
            NewProjectHandlerUtil.showMessage(Messages.NewProjectHandler_CouldntFindIdfPath);
            return false;
        }
        if (StringUtil.isEmpty((String)path)) {
            NewProjectHandlerUtil.showMessage(Messages.NewProjectHandler_CouldntFindPath);
            return false;
        }
        if (!isToolsInstalled) {
            NewProjectHandlerUtil.showMessage(Messages.NewProjectHandler_CouldntFindTools);
            return false;
        }
        return true;
    }

    private static void showMessage(final String missingMsg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean isYes = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.NewProjectHandler_PathErrorTitle, (String)(missingMsg + Messages.NewProjectHandler_NavigateToHelpMenu + Messages.NewProjectHandler_MandatoryMsg));
                if (isYes) {
                    ManageEspIdfVersionsHandler manageEspIdfVersionsHandler = new ManageEspIdfVersionsHandler();
                    try {
                        manageEspIdfVersionsHandler.execute(null);
                    }
                    catch (ExecutionException e) {
                        Logger.log((Exception)((Object)e));
                    }
                }
            }
        });
    }
}

