/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.handlers;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.FileUtil;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.IDFConsole;
import com.espressif.idf.ui.handlers.EclipseHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class HeapDumpAnalysisHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MessageConsoleStream messageConsoleStream = new IDFConsole().getConsoleStream();
        if (event.getApplicationContext() == null) {
            Logger.log((String)"App Context Null");
            messageConsoleStream.println("App Context Null");
            return null;
        }
        IResource dumpFile = EclipseHandler.getSelectedResource((IEvaluationContext)event.getApplicationContext());
        IProject selectedProject = dumpFile.getProject();
        IFile elfSymbolsFile = selectedProject.getFolder("build").getFile(selectedProject.getName().concat(".elf"));
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IDFUtil.getIDFPythonEnvPath());
        commands.add(IDFUtil.getIDFSysviewTraceScriptFile().getAbsolutePath());
        commands.add("-j");
        commands.add("-b");
        commands.add(elfSymbolsFile.getRawLocation().toOSString());
        commands.add("file://".concat(dumpFile.getRawLocation().toString()));
        messageConsoleStream.println("Commands Prepared");
        for (String command : commands) {
            messageConsoleStream.print(command);
            messageConsoleStream.print(" ");
        }
        Map envMap = new IDFEnvironmentVariables().getSystemEnvMap();
        Path pathToProject = new Path(selectedProject.getLocation().toString());
        String jsonOutput = this.runCommand(commands, pathToProject, envMap);
        FileUtil.writeFile((IProject)selectedProject, (String)"build/dump.json", (String)jsonOutput, (boolean)false);
        messageConsoleStream.println();
        messageConsoleStream.println(jsonOutput);
        this.launchEditor(selectedProject.getFile("build/dump.json"));
        return null;
    }

    private void launchEditor(IFile jsonDumpFile) {
        final FileEditorInput editorInput = new FileEditorInput(jsonDumpFile);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow activeww = EclipseHandler.getActiveWorkbenchWindow();
                try {
                    IDE.openEditor((IWorkbenchPage)activeww.getActivePage(), (IEditorInput)editorInput, (String)"com.espressif.idf.ui.editor.heapTraceAnalysis");
                }
                catch (PartInitException e) {
                    Logger.log((Exception)((Object)e));
                }
            }
        });
    }

    private String runCommand(List<String> arguments, Path workDir, Map<String, String> env) {
        String exportCmdOp = "";
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)workDir, env);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Status can't be null", null));
                return IDFCorePlugin.errorStatus((String)"Status can't be null", null).toString();
            }
            exportCmdOp = status.getMessage();
            Logger.log((String)exportCmdOp);
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
        }
        return exportCmdOp;
    }
}

