/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.dialogs;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.dialogs.Messages;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.resource.Resources;
import org.eclipse.ltk.internal.core.refactoring.resource.DeleteResourcesProcessor;
import org.eclipse.ltk.internal.ui.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.ltk.ui.refactoring.resource.DeleteResourcesWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DeleteResourceWizard
extends DeleteResourcesWizard {
    private static IProject project;
    private static boolean doDeleteRelatedConfigurations;

    public DeleteResourceWizard(IResource[] resources) {
        super(resources);
    }

    protected void addUserInputPages() {
        DeleteResourcesProcessor processor = (DeleteResourcesProcessor)this.getRefactoring().getAdapter(DeleteResourcesProcessor.class);
        this.addPage((IWizardPage)new DeleteResourcesRefactoringConfigurationPage(processor));
    }

    private static Set<IProject> computeNestedProjects(IResource[] initialResources) {
        if (initialResources == null) {
            return Collections.emptySet();
        }
        ArrayList<IResource> resources = new ArrayList<IResource>(Arrays.asList(initialResources));
        resources.removeIf(res -> res.getLocation() == null);
        Comparator pathComparator = (res1, res2) -> res1.getLocation().toString().compareTo(res2.getLocation().toString());
        resources.sort(pathComparator);
        if (resources.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<IProject> allProjects = new ArrayList<IProject>(Arrays.asList(initialResources[0].getWorkspace().getRoot().getProjects()));
        allProjects.removeIf(project -> project.getLocation() == null);
        allProjects.sort(pathComparator);
        int resourceIndex = 0;
        int projectIndex = 0;
        HashSet<IProject> res3 = new HashSet<IProject>();
        while (resourceIndex < resources.size() && projectIndex < allProjects.size()) {
            IProject project2;
            IPath projectPath;
            IPath resourcePath = ((IResource)resources.get(resourceIndex)).getLocation();
            if (resourcePath.isPrefixOf(projectPath = (project2 = (IProject)allProjects.get(projectIndex)).getLocation())) {
                res3.add(project2);
                ++projectIndex;
                continue;
            }
            int delta = resourcePath.toString().compareTo(projectPath.toString());
            if (delta < 0) {
                ++resourceIndex;
                continue;
            }
            ++projectIndex;
        }
        res3.removeAll(resources);
        return res3;
    }

    public boolean performFinish() {
        boolean performFinish = super.performFinish();
        if (doDeleteRelatedConfigurations) {
            this.deleteRelatedConfigurations();
        }
        return performFinish;
    }

    private void deleteRelatedConfigurations() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = launchManager.getLaunchConfigurations();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                IResource[] mappedResource = config.getMappedResources();
                if (mappedResource != null && mappedResource[0].getProject().equals((Object)project)) {
                    config.delete();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private static class DeleteResourcesRefactoringConfigurationPage
    extends UserInputWizardPage {
        private DeleteResourcesProcessor fRefactoringProcessor;
        private Button fDeleteContentsButton;
        private Button fDeleteAllRelatedConfigurationsButton;
        private StyledText fProjectLocationsList;
        private Label fProjectLocationsLabel;

        public DeleteResourcesRefactoringConfigurationPage(DeleteResourcesProcessor processor) {
            super("DeleteResourcesRefactoringConfigurationPage");
            this.fRefactoringProcessor = processor;
        }

        public void createControl(Composite parent) {
            doDeleteRelatedConfigurations = false;
            this.initializeDialogUnits((Control)parent);
            Point defaultSpacing = LayoutConstants.getSpacing();
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.horizontalSpacing = defaultSpacing.x * 2;
            gridLayout.verticalSpacing = defaultSpacing.y;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Image image = parent.getDisplay().getSystemImage(4);
            Label imageLabel = new Label(composite, 0);
            if (image != null) {
                imageLabel.setBackground(image.getBackground());
                imageLabel.setImage(image);
            }
            imageLabel.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
            final IResource[] initialResources = this.fRefactoringProcessor.getResourcesToDelete();
            Label label = new Label(composite, 64);
            boolean onlyProjects = Resources.containsOnlyProjects((IResource[])initialResources);
            if (onlyProjects) {
                if (initialResources.length == 1) {
                    label.setText(org.eclipse.ltk.internal.ui.refactoring.Messages.format((String)RefactoringUIMessages.DeleteResourcesWizard_label_single_project, (Object)BasicElementLabels.getResourceName((IResource)initialResources[0])));
                    project = (IProject)initialResources[0];
                } else {
                    label.setText(org.eclipse.ltk.internal.ui.refactoring.Messages.format((String)RefactoringUIMessages.DeleteResourcesWizard_label_multi_projects, (Object)initialResources.length));
                }
            } else if (this.containsLinkedResource(initialResources)) {
                if (initialResources.length == 1) {
                    label.setText(org.eclipse.ltk.internal.ui.refactoring.Messages.format((String)RefactoringUIMessages.DeleteResourcesWizard_label_single_linked, (Object)BasicElementLabels.getResourceName((IResource)initialResources[0])));
                } else {
                    label.setText(org.eclipse.ltk.internal.ui.refactoring.Messages.format((String)RefactoringUIMessages.DeleteResourcesWizard_label_multi_linked, (Object)initialResources.length));
                }
            } else if (initialResources.length == 1) {
                label.setText(org.eclipse.ltk.internal.ui.refactoring.Messages.format((String)RefactoringUIMessages.DeleteResourcesWizard_label_single, (Object)BasicElementLabels.getResourceName((IResource)initialResources[0])));
            } else {
                label.setText(org.eclipse.ltk.internal.ui.refactoring.Messages.format((String)RefactoringUIMessages.DeleteResourcesWizard_label_multi, (Object)initialResources.length));
            }
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)gridData);
            Composite supportArea = new Composite(composite, 0);
            supportArea.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            gridLayout = new GridLayout(1, false);
            gridLayout.horizontalSpacing = defaultSpacing.x * 2;
            gridLayout.verticalSpacing = defaultSpacing.y;
            supportArea.setLayout((Layout)gridLayout);
            if (onlyProjects) {
                Set<IProject> nestedProjects = DeleteResourceWizard.computeNestedProjects(initialResources);
                this.fDeleteContentsButton = new Button(supportArea, 32);
                this.fDeleteContentsButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                this.fDeleteContentsButton.setText(RefactoringUIMessages.DeleteResourcesWizard_project_deleteContents);
                this.fDeleteContentsButton.setFocus();
                this.fDeleteAllRelatedConfigurationsButton = new Button(supportArea, 32);
                this.fDeleteAllRelatedConfigurationsButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                this.fDeleteAllRelatedConfigurationsButton.setText(Messages.DeleteResourcesWizard_project_deleteConfigurations);
                if (!nestedProjects.isEmpty()) {
                    final HashSet<Object> projectHierarchy = new HashSet<Object>(initialResources.length + nestedProjects.size(), 1.0f);
                    projectHierarchy.addAll(Arrays.asList(this.fRefactoringProcessor.getResourcesToDelete()));
                    projectHierarchy.addAll(nestedProjects);
                    final Button deleteNestedProjectsCheckbox = new Button(supportArea, 32);
                    deleteNestedProjectsCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                    deleteNestedProjectsCheckbox.setText(nestedProjects.size() == 1 ? RefactoringUIMessages.DeleteResourcesWizard_label_alsoDeleteOneNestedProject : NLS.bind((String)RefactoringUIMessages.DeleteResourcesWizard_label_alsoDeleteNestedProjects, (Object)nestedProjects.size()));
                    SelectionAdapter deleteNestedProjectsCheckboxListener = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            boolean deleteNestedProjects = deleteNestedProjectsCheckbox.getSelection();
                            try {
                                this.getContainer().run(false, true, pm -> {
                                    try {
                                        fRefactoringProcessor.setResources(deleteNestedProjects ? projectHierarchy.toArray(new IResource[projectHierarchy.size()]) : initialResources, pm);
                                    }
                                    catch (CoreException | OperationCanceledException ex) {
                                        throw new InvocationTargetException(ex);
                                    }
                                });
                                this.updateListOfProjects();
                            }
                            catch (InterruptedException | InvocationTargetException ex) {
                                RefactoringUIPlugin.log((Throwable)ex);
                            }
                        }
                    };
                    deleteNestedProjectsCheckbox.addSelectionListener((SelectionListener)deleteNestedProjectsCheckboxListener);
                    this.fDeleteContentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
                        private boolean previousNestedProjectSelection;

                        public void widgetSelected(SelectionEvent e) {
                            if (fDeleteContentsButton.getSelection()) {
                                this.previousNestedProjectSelection = deleteNestedProjectsCheckbox.getSelection();
                                deleteNestedProjectsCheckbox.setSelection(true);
                            } else {
                                deleteNestedProjectsCheckbox.setSelection(this.previousNestedProjectSelection);
                            }
                            deleteNestedProjectsCheckbox.setEnabled(!fDeleteContentsButton.getSelection());
                            super.widgetSelected(e);
                        }
                    });
                    this.fDeleteContentsButton.addSelectionListener((SelectionListener)deleteNestedProjectsCheckboxListener);
                }
                this.fDeleteAllRelatedConfigurationsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        doDeleteRelatedConfigurations = fDeleteAllRelatedConfigurationsButton.getSelection();
                    }
                });
                this.fProjectLocationsLabel = new Label(supportArea, 0);
                GridData labelData = new GridData(4, 4, true, false);
                labelData.verticalIndent = 5;
                this.fProjectLocationsLabel.setLayoutData((Object)labelData);
                int style = 586;
                if (initialResources.length > 1 || !nestedProjects.isEmpty()) {
                    style |= 0x800;
                }
                this.fProjectLocationsList = new StyledText(supportArea, style);
                this.fProjectLocationsList.setAlwaysShowScrollBars(false);
                labelData.horizontalIndent = this.fProjectLocationsList.getLeftMargin();
                gridData = new GridData(4, 4, true, true);
                gridData.heightHint = this.convertHeightInCharsToPixels(Math.min(initialResources.length + nestedProjects.size(), 5));
                this.fProjectLocationsList.setLayoutData((Object)gridData);
                this.fProjectLocationsList.setBackground(this.fProjectLocationsList.getDisplay().getSystemColor(22));
                Dialog.applyDialogFont((Control)this.fProjectLocationsList);
                this.updateListOfProjects();
            }
            this.setControl((Control)composite);
        }

        private void updateListOfProjects() {
            IResource[] initialResources = this.fRefactoringProcessor.getResourcesToDelete();
            StringBuilder buf = new StringBuilder();
            IResource[] iResourceArray = initialResources;
            int n = initialResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource initialResource = iResourceArray[n2];
                String location = DeleteResourcesRefactoringConfigurationPage.getLocation(initialResource);
                if (location != null) {
                    if (buf.length() > 0) {
                        buf.append('\n');
                    }
                    buf.append(location);
                }
                ++n2;
            }
            this.fProjectLocationsList.setText(buf.toString());
            this.fProjectLocationsLabel.setText(initialResources.length == 1 ? RefactoringUIMessages.DeleteResourcesWizard_project_location : NLS.bind((String)RefactoringUIMessages.DeleteResourcesWizard_project_locations, (Object)initialResources.length));
            this.fProjectLocationsList.getParent().pack(true);
            this.fProjectLocationsList.getParent().requestLayout();
        }

        private static String getLocation(IResource resource) {
            IPath location = resource.getLocation();
            if (location != null) {
                return BasicElementLabels.getPathLabel((IPath)location, (boolean)true);
            }
            URI uri = resource.getLocationURI();
            if (uri != null) {
                return BasicElementLabels.getURLPart((String)uri.toString());
            }
            URI rawLocationURI = resource.getRawLocationURI();
            if (rawLocationURI != null) {
                return BasicElementLabels.getURLPart((String)rawLocationURI.toString());
            }
            return BasicElementLabels.getResourceName((IResource)resource);
        }

        private boolean containsLinkedResource(IResource[] resources) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource != null && resource.isLinked()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void initializeRefactoring() {
            this.fRefactoringProcessor.setDeleteContents(this.fDeleteContentsButton == null ? false : this.fDeleteContentsButton.getSelection());
        }

        private void storeSettings() {
        }
    }
}

