/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.dialogs;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.LaunchTargetHelper;
import com.espressif.idf.core.util.RecheckConfigsHelper;
import com.espressif.idf.ui.dialogs.Messages;
import java.util.Map;
import org.eclipse.cdt.debug.core.launch.CoreBuildLaunchConfigDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.ui.corebuild.CommonBuildTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CMakeBuildTab2
extends CommonBuildTab {
    private static final String LOCAL_CMAKE_ARGUMENTS = "local_cmake_arguments";
    private static final String UNIX_MAKEFILES = "Unix Makefiles";
    private static final String NINJA = "Ninja";
    private static final String DEFAULT_CMAKE_MSG = "";
    private static final String DEFAULT_BUILD_MSG = "cmake --build .";
    private static final String DEFAULT_CLEAN_MSG = "ninja clean";
    private Button unixGenButton;
    private Button ninjaGenButton;
    private Text cmakeArgsText;
    private Text buildCommandText;
    private Text cleanCommandText;
    private Text buildFolderText;

    protected String getBuildConfigProviderId() {
        return "com.espressif.idf.cmake.core.provider";
    }

    public void createControl(final Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.setControl((Control)comp);
        Control tcControl = this.createToolchainSelector(comp);
        tcControl.setLayoutData((Object)new GridData(4, 4, true, false));
        Group cmakeGroup = new Group(comp, 0);
        cmakeGroup.setText(Messages.CMakeBuildTab2_CMakeSettings);
        cmakeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        cmakeGroup.setLayout((Layout)new GridLayout());
        Label label = new Label((Composite)cmakeGroup, 0);
        label.setText(Messages.CMakeBuildTab2_Generator);
        Composite genComp = new Composite((Composite)cmakeGroup, 2048);
        genComp.setLayout((Layout)new GridLayout(2, true));
        this.unixGenButton = new Button(genComp, 16);
        this.unixGenButton.setText(Messages.CMakeBuildTab2_UnixMakeFiles);
        this.unixGenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeBuildTab2.this.updateLaunchConfigurationDialog();
            }
        });
        this.ninjaGenButton = new Button(genComp, 16);
        this.ninjaGenButton.setText(Messages.CMakeBuildTab2_Ninja);
        this.ninjaGenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeBuildTab2.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label((Composite)cmakeGroup, 0);
        label.setText(Messages.CMakeBuildTab2_BuildFolderTextLbl);
        Composite buildFolderComp = new Composite((Composite)cmakeGroup, 0);
        buildFolderComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buildFolderComp.setLayout((Layout)new GridLayout(2, false));
        this.buildFolderText = new Text(buildFolderComp, 2048);
        this.buildFolderText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buildFolderText.setMessage(Messages.CMakeBuildTab2_BuildFolderTextMsg);
        this.buildFolderText.setToolTipText(Messages.CMakeBuildTab2_BuildFolderTextToolTip);
        Button browseButton = this.createPushButton(buildFolderComp, LaunchMessages.Launch_common_Browse_1, null);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
                dialog.setMessage(Messages.CMakeBuildTab2_SelectBuildFolderMsg);
                String selectedDir = dialog.open();
                if (selectedDir != null) {
                    CMakeBuildTab2.this.buildFolderText.setText(selectedDir);
                }
            }
        });
        label = new Label((Composite)cmakeGroup, 0);
        label.setText(Messages.CMakeBuildTab2_AdditionalCMakeArgs);
        this.cmakeArgsText = new Text((Composite)cmakeGroup, 2048);
        this.cmakeArgsText.setMessage(DEFAULT_CMAKE_MSG);
        this.cmakeArgsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cmakeArgsText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        label = new Label((Composite)cmakeGroup, 0);
        label.setText(Messages.CMakeBuildTab2_BuildCmd);
        this.buildCommandText = new Text((Composite)cmakeGroup, 2048);
        this.buildCommandText.setMessage(DEFAULT_BUILD_MSG);
        this.buildCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buildCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        label = new Label((Composite)cmakeGroup, 0);
        label.setText(Messages.CMakeBuildTab2_CleanCmd);
        this.cleanCommandText = new Text((Composite)cmakeGroup, 2048);
        this.cleanCommandText.setMessage(DEFAULT_CLEAN_MSG);
        this.cleanCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cleanCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            IProject project = CoreBuildLaunchConfigDelegate.getProject((ILaunchConfiguration)configuration);
            RecheckConfigsHelper.revalidateToolchain((IProject)project);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        configuration.setAttribute("cmake.generator", NINJA);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            IProject project = CoreBuildLaunchConfigDelegate.getProject((ILaunchConfiguration)configuration);
            RecheckConfigsHelper.revalidateToolchain((IProject)project);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        try {
            String buildFolderPath = configuration.getAttribute("com.espressif.idf.launch.serial.core.idfBuildFolderPath", DEFAULT_CMAKE_MSG);
            this.buildFolderText.setText(buildFolderPath);
            String generator = configuration.getAttribute("cmake.generator", DEFAULT_CMAKE_MSG);
            this.updateGeneratorButtons(generator);
            String cmakeArgs = configuration.getAttribute(LOCAL_CMAKE_ARGUMENTS, configuration.getAttribute("cmake.arguments", DEFAULT_CMAKE_MSG));
            this.cmakeArgsText.setText(cmakeArgs);
            String buildCommand = configuration.getAttribute("cmake.command.build", DEFAULT_CMAKE_MSG);
            this.buildCommandText.setText(buildCommand);
            String cleanCommand = configuration.getAttribute("cmake.target.clean", DEFAULT_CMAKE_MSG);
            this.cleanCommandText.setText(cleanCommand);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private void updateGeneratorButtons(String generator) {
        if (generator == null || generator.equals(NINJA) || generator.isBlank()) {
            this.ninjaGenButton.setSelection(true);
        } else {
            this.unixGenButton.setSelection(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String buildCommand;
        super.performApply(configuration);
        IProject project = null;
        try {
            project = CoreBuildLaunchConfigDelegate.getProject((ILaunchConfiguration)configuration);
            RecheckConfigsHelper.revalidateToolchain((IProject)project);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        configuration.setAttribute("com.espressif.idf.launch.serial.core.idfBuildFolderPath", this.buildFolderText.getText());
        configuration.setAttribute("cmake.generator", this.ninjaGenButton.getSelection() ? NINJA : UNIX_MAKEFILES);
        String cmakeArgs = this.cmakeArgsText.getText().trim();
        if (!cmakeArgs.isEmpty()) {
            configuration.setAttribute(LOCAL_CMAKE_ARGUMENTS, cmakeArgs);
            if (project != null) {
                configuration.setAttribute("cmake.arguments", cmakeArgs);
            }
        } else {
            configuration.removeAttribute(LOCAL_CMAKE_ARGUMENTS);
            configuration.removeAttribute("cmake.arguments");
        }
        if (!(buildCommand = this.buildCommandText.getText().trim()).isEmpty()) {
            configuration.setAttribute("cmake.command.build", buildCommand);
        } else {
            configuration.removeAttribute("cmake.command.build");
        }
        String cleanCommand = this.cleanCommandText.getText().trim();
        if (!cleanCommand.isEmpty()) {
            configuration.setAttribute("cmake.target.clean", cleanCommand);
        } else {
            configuration.removeAttribute("cmake.target.clean");
        }
    }

    protected void saveProperties(Map<String, String> properties) {
        super.saveProperties(properties);
        properties.put("cmake.generator", this.ninjaGenButton.getSelection() ? NINJA : UNIX_MAKEFILES);
        properties.put("com.espressif.idf.launch.serial.core.idfBuildFolderPath", this.buildFolderText.getText().trim());
        properties.put(LOCAL_CMAKE_ARGUMENTS, this.cmakeArgsText.getText().trim());
        properties.put("cmake.command.build", this.buildCommandText.getText().trim());
        properties.put("cmake.target.clean", this.cleanCommandText.getText().trim());
    }

    protected void restoreProperties(Map<String, String> properties) {
        String cmakeArgs;
        String buildFolderPath;
        block14: {
            super.restoreProperties(properties);
            String gen = properties.get("cmake.generator");
            if (gen == null) break block14;
            switch (gen) {
                case "Unix Makefiles": {
                    this.ninjaGenButton.setSelection(false);
                    this.unixGenButton.setSelection(true);
                    break;
                }
                default: {
                    this.ninjaGenButton.setSelection(true);
                    this.unixGenButton.setSelection(false);
                }
            }
        }
        if ((buildFolderPath = properties.get("com.espressif.idf.launch.serial.core.idfBuildFolderPath")) != null) {
            this.buildFolderText.setText(buildFolderPath);
        }
        if ((cmakeArgs = properties.get(LOCAL_CMAKE_ARGUMENTS)) != null) {
            this.cmakeArgsText.setText(cmakeArgs);
        } else {
            this.cmakeArgsText.setText(DEFAULT_CMAKE_MSG);
        }
        String buildCmd = properties.get("cmake.command.build");
        if (buildCmd != null) {
            this.buildCommandText.setText(buildCmd);
        } else {
            this.buildCommandText.setText(DEFAULT_CMAKE_MSG);
        }
        String cleanCmd = properties.get("cmake.target.clean");
        if (cleanCmd != null) {
            this.cleanCommandText.setText(cleanCmd);
        } else {
            this.cleanCommandText.setText(DEFAULT_CMAKE_MSG);
        }
    }

    public ILaunchTarget getLaunchTarget() {
        ILaunchTarget selectedTarget;
        ILaunchTarget defaultTarget = super.getLaunchTarget();
        ILaunchTargetManager launchTargetManager = (ILaunchTargetManager)IDFCorePlugin.getService(ILaunchTargetManager.class);
        String targetName = LaunchTargetHelper.getLastTargetName().orElseGet(() -> defaultTarget != null ? defaultTarget.getId() : DEFAULT_CMAKE_MSG);
        if (!targetName.isEmpty() && (selectedTarget = LaunchTargetHelper.findLaunchTargetByName((ILaunchTargetManager)launchTargetManager, (String)targetName)) != null) {
            return selectedTarget;
        }
        try {
            ILaunchTarget activeILaunchTarget = ((ILaunchBarManager)IDFCorePlugin.getService(ILaunchBarManager.class)).getActiveLaunchTarget();
            return activeILaunchTarget != null ? activeILaunchTarget : defaultTarget;
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return defaultTarget;
        }
    }

    public String getName() {
        return "CMake";
    }
}

