/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.SDKConfigUtil;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SDKConfigJsonReader {
    private IProject project;

    public SDKConfigJsonReader(IProject project) {
        this.project = project;
    }

    public String getValue(String key) {
        try {
            JSONObject jsonObj = this.read();
            if (jsonObj != null) {
                return String.valueOf(jsonObj.get((Object)key));
            }
        }
        catch (Exception e) {
            Logger.log(e, true);
        }
        return null;
    }

    protected JSONObject read() throws Exception {
        String sdkconfigJsonPath = new SDKConfigUtil().getSDKConfigJsonFilePath(this.project);
        if (!new File(sdkconfigJsonPath).exists()) {
            Logger.log(MessageFormat.format("sdkconfig.json file could not find {0}", sdkconfigJsonPath));
            return null;
        }
        JSONParser parser = new JSONParser();
        try (FileReader reader = new FileReader(sdkconfigJsonPath);){
            JSONObject jSONObject = (JSONObject)parser.parse((Reader)reader);
            return jSONObject;
        }
    }
}

