/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.build.PartitionTableBean;
import com.espressif.idf.core.logging.Logger;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class PartitionTableDataUtil {
    public static List<PartitionTableBean> parseCsv(Path csvFile) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader reader = Files.newBufferedReader(csvFile);){
            CsvToBean csvToBean = null;
            csvToBean = new CsvToBeanBuilder((Reader)reader).withSkipLines(2).withType(PartitionTableBean.class).build();
            List beansList = csvToBean.parse();
            return beansList;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void saveCsv(IFile csvFile, List<PartitionTableBean> beansToSave) {
        File newFile = new File(csvFile.getLocationURI());
        if (!csvFile.exists()) {
            try {
                newFile.createNewFile();
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
        try {
            Throwable e = null;
            Object var4_9 = null;
            try (FileWriter writer = new FileWriter(newFile);){
                StatefulBeanToCsv sbc = new StatefulBeanToCsvBuilder((Writer)writer).withQuotechar('\u0000').withSeparator(',').build();
                writer.write("# ESP-IDF Partition Table\n");
                writer.write("# Name,   Type, SubType, Offset,  Size, Flags\n");
                if (beansToSave.isEmpty()) {
                    PartitionTableDataUtil.writeDefaultValues(writer);
                } else {
                    sbc.write(beansToSave);
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            Logger.log(e);
        }
        catch (CsvDataTypeMismatchException e) {
            Logger.log((Exception)((Object)e));
        }
        catch (CsvRequiredFieldEmptyException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private static void writeDefaultValues(Writer writer) throws IOException {
        writer.write("nvs,      data, nvs,     0x9000,  0x6000,\n");
        writer.write("phy_init, data, phy,     0xf000,  0x1000,\n");
        writer.write("factory,  app,  factory, 0x10000, 1M,\n");
    }

    public static String[] getTypeValues() {
        String[] typeValues = new String[]{"app", "data"};
        return typeValues;
    }

    public static String[] getSubTypeValues(String type) {
        String[] matchedSubTypes = null;
        String[] dataSubTypeValues = new String[]{"fat", "ota", "phy", "nvs", "nvs_keys", "spiffs"};
        String[] appSubTypeValues = new String[]{"factory", "ota_0", "ota_1", "ota_2", "ota_3", "ota_4", "ota_5", "ota_6", "ota_7", "ota_8", "ota_9", "ota_10", "ota_11", "ota_12", "ota_13", "ota_14", "ota_15", "test"};
        matchedSubTypes = type.contentEquals("0x00") || type.contentEquals("app") ? appSubTypeValues : matchedSubTypes;
        matchedSubTypes = type.contentEquals("0x01") || type.contentEquals("data") ? dataSubTypeValues : matchedSubTypes;
        matchedSubTypes = matchedSubTypes == null ? PartitionTableDataUtil.supportedSubTypeHexRange() : matchedSubTypes;
        return matchedSubTypes;
    }

    private static String[] supportedSubTypeHexRange() {
        String[] hexRange = new String[255];
        Object incHex = Integer.toHexString(0);
        int i = 0;
        while (i < hexRange.length) {
            incHex = ((String)incHex).length() == 1 ? "0" + (String)incHex : incHex;
            hexRange[i] = "0x" + ((String)incHex).toUpperCase();
            int value = Integer.parseInt((String)incHex, 16);
            incHex = Integer.toHexString(++value);
            ++i;
        }
        return hexRange;
    }
}

