/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.build.NvsTableBean;
import com.espressif.idf.core.util.Messages;
import com.espressif.idf.core.util.NvsTableDataService;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NvsBeanValidator {
    private static final int STRING_VALUE_LIMIT = 4000;
    private static final String NAMESPACE = "namespace";
    private static final Map<String, BigInteger> minValuesMap = NvsBeanValidator.initMinValuesMap();
    private static final Map<String, BigInteger> maxValuesMap = NvsBeanValidator.initMaxValuesMap();

    public String validateBean(NvsTableBean bean, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.validateKey(bean.getKey());
            }
            case 1: {
                return this.validateType(bean.getType());
            }
            case 2: {
                return this.validateEncoding(bean.getEncoding(), bean.getType());
            }
            case 3: {
                return this.validateValue(bean.getValue(), bean.getType(), bean.getEncoding());
            }
        }
        return "";
    }

    private static Map<String, BigInteger> initMinValuesMap() {
        HashMap<String, BigInteger> minValuesMap = new HashMap<String, BigInteger>();
        minValuesMap.put("u8", BigInteger.valueOf(0L));
        minValuesMap.put("i8", BigInteger.valueOf(-128L));
        minValuesMap.put("u16", BigInteger.valueOf(0L));
        minValuesMap.put("i16", BigInteger.valueOf(-32768L));
        minValuesMap.put("u32", BigInteger.valueOf(0L));
        minValuesMap.put("i32", BigInteger.valueOf(Integer.MIN_VALUE));
        minValuesMap.put("u64", BigInteger.valueOf(0L));
        minValuesMap.put("i64", BigInteger.valueOf(Long.MIN_VALUE));
        return minValuesMap;
    }

    private static Map<String, BigInteger> initMaxValuesMap() {
        HashMap<String, BigInteger> maxValuesMap = new HashMap<String, BigInteger>();
        maxValuesMap.put("u8", BigInteger.valueOf(255L));
        maxValuesMap.put("i8", BigInteger.valueOf(127L));
        maxValuesMap.put("u16", BigInteger.valueOf(65535L));
        maxValuesMap.put("i16", BigInteger.valueOf(32767L));
        maxValuesMap.put("u32", BigInteger.valueOf(Integer.toUnsignedLong(-1)));
        maxValuesMap.put("i32", BigInteger.valueOf(Integer.MAX_VALUE));
        maxValuesMap.put("u64", new BigInteger("18446744073709551615"));
        maxValuesMap.put("i64", BigInteger.valueOf(Long.MAX_VALUE));
        return maxValuesMap;
    }

    public String validateFirstBean(NvsTableBean bean) {
        if (!bean.getType().contentEquals(NAMESPACE)) {
            return Messages.NvsValidation_FirstBeanValidationErr;
        }
        return "";
    }

    private String validateValue(String value, String type, String encoding) {
        if (type.contentEquals(NAMESPACE) && !value.isBlank()) {
            return Messages.NvsValidation_ValueValidationErr_1;
        }
        if (type.contentEquals(NAMESPACE) && value.isBlank()) {
            return "";
        }
        if (value.isBlank()) {
            return Messages.NvsValidation_ValueValidationErr_2;
        }
        if (type.contentEquals("file")) {
            return "";
        }
        if (encoding.contentEquals("string") || encoding.contentEquals("binary")) {
            if (value.getBytes().length > 4000) {
                return Messages.NvsValidation_ValueValidationErr_3;
            }
            return "";
        }
        if (minValuesMap.containsKey(encoding)) {
            return this.validateNumber(value, encoding);
        }
        return "";
    }

    private String validateNumber(String value, String encoding) {
        BigInteger bigIntegerValue = null;
        try {
            bigIntegerValue = new BigInteger(value);
        }
        catch (NumberFormatException e) {
            return String.format(Messages.NvsValidation_NumberValueValidationErr_1, e.getLocalizedMessage());
        }
        if (bigIntegerValue.compareTo(minValuesMap.get(encoding)) >= 0 && bigIntegerValue.compareTo(maxValuesMap.get(encoding)) <= 0) {
            return "";
        }
        return String.format(Messages.NvsValidation_NumberValueValidationErr_2, value, encoding);
    }

    private String validateEncoding(String encoding, String type) {
        if (!List.of(NvsTableDataService.getEncodings(type)).contains(encoding)) {
            return String.format(Messages.NvsValidation_EncodingValidationErr_1, type, String.join((CharSequence)",", NvsTableDataService.getEncodings(type)), encoding);
        }
        return "";
    }

    private String validateType(String type) {
        return "";
    }

    private String validateKey(String key) {
        if (key.isBlank()) {
            return Messages.NvsValidation_KeyValidationErr_1;
        }
        if (key.length() > 15) {
            return Messages.NvsValidation_KeyValidationErr_2;
        }
        return "";
    }
}

