/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.build.ActiveLaunchConfigurationProvider;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class IdfCommandExecutor {
    private final String target;
    private final MessageConsole console;
    private static final String CMAKE_ARGUMENTS = "cmake.arguments";
    private static final ActiveLaunchConfigurationProvider LAUNCH_CONFIG_PROVIDER = new ActiveLaunchConfigurationProvider();

    public IdfCommandExecutor(String target, MessageConsole console) {
        this.target = target;
        this.console = console;
    }

    public IStatus executeReconfigure(IProject project) {
        this.console.activate();
        return this.runIdfReconfigureCommand(project);
    }

    private IStatus runIdfReconfigureCommand(IProject project) {
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        List<String> arguments = this.prepareCmakeArguments(project);
        HashMap<String, String> environment = new HashMap<String, String>(new IDFEnvironmentVariables().getSystemEnvMap());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (MessageConsoleStream messageConsoleStream = this.console.newMessageStream();){
                messageConsoleStream.println(String.join((CharSequence)" ", arguments));
                return this.runProcess(arguments, environment, processRunner, project, messageConsoleStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            Logger.log(e1);
            return IDFCorePlugin.errorStatus(e1.getMessage(), e1);
        }
    }

    private List<String> prepareCmakeArguments(IProject project) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(IDFUtil.findCommandFromBuildEnvPath("cmake"));
        arguments.add("-G");
        arguments.add("Ninja");
        arguments.add("-DPYTHON_DEPS_CHECKED=1");
        arguments.add("-DPYTHON=" + IDFUtil.getIDFPythonEnvPath());
        arguments.add("-DESP_PLATFORM=1");
        arguments.add("-DIDF_TARGET=" + this.target);
        String ccache = new IDFEnvironmentVariables().getEnvValue("IDF_CCACHE_ENABLE");
        ccache = ccache.isBlank() ? "0" : ccache;
        arguments.add("-DCCACHE_ENABLE=" + ccache);
        arguments.add(project.getLocation().toOSString());
        arguments.add("-B");
        try {
            arguments.add(IDFUtil.getBuildDir(project));
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return arguments;
    }

    public String getProperty(String name) {
        try {
            ILaunchConfiguration configuration = LAUNCH_CONFIG_PROVIDER.getActiveLaunchConfiguration();
            if (configuration != null && configuration.getType().getIdentifier().equals("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationType")) {
                configuration = this.getBoundConfiguration(configuration);
            }
            return configuration == null ? "" : configuration.getAttribute(name, "");
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return "";
        }
    }

    private ILaunchConfiguration getBoundConfiguration(ILaunchConfiguration configuration) throws CoreException {
        String bindedLaunchConfigName = configuration.getAttribute("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationName", "");
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.espressif.idf.launch.serial.launchConfigurationType"));
        ILaunchConfiguration defaultConfiguration = launchConfigurations[0];
        return Stream.of(launchConfigurations).filter(config -> config.getName().contentEquals(bindedLaunchConfigName)).findFirst().orElse(defaultConfiguration);
    }

    private IStatus runProcess(List<String> arguments, Map<String, String> environment, ProcessBuilderFactory processRunner, IProject project, MessageConsoleStream messageConsoleStream) {
        StringBuilder output = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(processRunner.run(arguments, project.getLocation(), environment).getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append(System.lineSeparator());
                    messageConsoleStream.println(line);
                }
                return new Status(0, "com.espressif.idf.core", output.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Logger.log(e);
            return IDFCorePlugin.errorStatus(e.getMessage(), e);
        }
    }
}

