/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.build;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.build.IDFBuildConfiguration;
import com.espressif.idf.core.logging.Logger;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public class IDFBuildConfigurationProvider
implements ICBuildConfigurationProvider {
    public static final String ID = "com.espressif.idf.cmake.core.provider";
    private ICMakeToolChainManager manager = (ICMakeToolChainManager)CCorePlugin.getService(ICMakeToolChainManager.class);
    private ICBuildConfigurationManager configManager = (ICBuildConfigurationManager)CCorePlugin.getService(ICBuildConfigurationManager.class);

    public String getId() {
        return ID;
    }

    public synchronized ICBuildConfiguration getCBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        ILaunchTarget target;
        ILaunchBarManager barManager = IDFCorePlugin.getService(ILaunchBarManager.class);
        ILaunchTarget iLaunchTarget = target = barManager != null ? barManager.getActiveLaunchTarget() : null;
        if (config.getName().equals("")) {
            Logger.log("Default config name is not supported");
            return null;
        }
        IDFBuildConfiguration cmakeConfig = new IDFBuildConfiguration(config, name);
        ICMakeToolChainFile tcFile = cmakeConfig.getToolChainFile();
        IToolChain toolChain = cmakeConfig.getToolChain();
        if (toolChain == null) {
            Logger.log("Toolchain is null");
            return null;
        }
        if (tcFile != null && !toolChain.equals(tcFile.getToolChain())) {
            return new IDFBuildConfiguration(config, name, tcFile.getToolChain(), tcFile, cmakeConfig.getLaunchMode(), target);
        }
        return cmakeConfig;
    }

    public ICBuildConfiguration createCBuildConfiguration(IProject project, IToolChain toolChain, String launchMode, ILaunchTarget launchTarget, IProgressMonitor monitor) throws CoreException {
        String name;
        Collection files;
        String arch;
        HashMap<String, String> properties = new HashMap<String, String>();
        String os = toolChain.getProperty("os");
        if (os != null && !os.isEmpty()) {
            properties.put("os", os);
        }
        if ((arch = toolChain.getProperty("arch")) != null && !arch.isEmpty()) {
            properties.put("arch", arch);
        }
        properties.put("ATTR_ID", toolChain.getProperty("ATTR_ID"));
        ICMakeToolChainFile file = this.manager.getToolChainFileFor(toolChain);
        if (file == null && !(files = this.manager.getToolChainFilesMatching(properties)).isEmpty()) {
            file = (ICMakeToolChainFile)files.iterator().next();
        }
        IBuildConfiguration buildConfig = this.configManager.hasConfiguration((ICBuildConfigurationProvider)this, project, name = "cdt.toolChain.id") ? project.getBuildConfig("com.espressif.idf.cmake.core.provider/" + name) : this.configManager.createBuildConfiguration((ICBuildConfigurationProvider)this, project, name, monitor);
        IDFBuildConfiguration cmakeConfig = new IDFBuildConfiguration(buildConfig, name, toolChain, file, launchMode, launchTarget);
        this.configManager.addBuildConfiguration(buildConfig, (ICBuildConfiguration)cmakeConfig);
        return cmakeConfig;
    }
}

