/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.launch.serial.ui.internal;

import com.espressif.idf.core.IDFDynamicVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.DfuCommandsUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.core.variable.JtagDynamicVariable;
import com.espressif.idf.core.variable.OpenocdDynamicVariable;
import com.espressif.idf.launch.serial.ui.internal.Messages;
import com.espressif.idf.launch.serial.util.ESPFlashUtil;
import com.espressif.idf.swt.custom.StyledInfoText;
import com.espressif.idf.swt.custom.TextWithButton;
import com.espressif.idf.ui.EclipseUtil;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.ui.corebuild.GenericMainTab;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.ide.IDEEncoding;

public class CMakeMainTab2
extends GenericMainTab {
    private static final String DOCS_ESPRESSIF_FLASH_ENCRYPTION_HTML = "https://docs.espressif.com/projects/espressif-ide/en/latest/flashdevice.html#customize-flash-arguments";
    private static final String DEFAULT_JTAG_CONFIG_OPTIONS = String.format("-s ${%s} ${%s}", OpenocdDynamicVariable.OPENOCD_SCRIPTS, JtagDynamicVariable.JTAG_FLASH_ARGS);
    private Combo flashOverComboButton;
    private boolean isFlashOverJtag;
    private boolean isJtagFlashAvailable;
    private Text fProjText;
    private IProject selectedProject;
    private Composite mainComposite;
    private EnumMap<FlashInterface, List<Composite>> switchComposites = new EnumMap(FlashInterface.class);
    private EnumMap<FlashInterface, List<GridData>> switchGridDatas = new EnumMap(FlashInterface.class);
    private TextWithButton uartAgrumentsField;
    private TextWithButton jtagArgumentsField;
    private TextWithButton dfuArgumentsField;
    private Button checkOpenSerialMonitorButton;
    private Combo fEncodingCombo;
    private Button flashEncryptionCheckbox;

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        this.mainComposite.setLayout((Layout)layout);
        this.mainComposite.setLayoutData((Object)gridData);
        StyledInfoText styledInfoText = new StyledInfoText(this.mainComposite);
        styledInfoText.setMouseListenerAction(() -> {
            this.initializeFromDefaults();
            this.scheduleUpdateJob();
        });
        this.isJtagFlashAvailable = ESPFlashUtil.checkIfJtagIsAvailable();
        this.setControl((Control)this.mainComposite);
        this.createJtagFlashButton(this.mainComposite);
        this.createOpenSerialMonitorGroup(this.mainComposite);
        this.createProjectGroup(this.mainComposite, 0);
        this.createUartComposite(this.mainComposite);
        this.createJtagflashComposite(this.mainComposite);
        this.createDfuArgumentField(this.mainComposite);
        this.argumentField = new Text(parent, 2626);
        this.argumentField.setVisible(false);
    }

    protected void updateArgument(ILaunchConfiguration configuration) {
    }

    protected void createArgumentComponent(Composite parent, TextWithButton argumentField) {
        Group group = new Group(parent, 0);
        String groupName = Messages.CMakeMainTab2_Arguments;
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        group.setFont(parent.getFont());
        argumentField.setParent(group);
        argumentField.addTraverseListener(event -> {
            if (event.detail == 4 && (event.stateMask & SWT.MODIFIER_MASK) != 0) {
                event.doit = true;
            }
        });
        gridData = new GridData(1808);
        gridData.widthHint = 200;
        argumentField.setLayoutData(gridData);
        argumentField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener(argumentField.getControl(), group.getText());
        Composite composite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        gridData = new GridData(128);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        composite.setFont(parent.getFont());
        Button argumentVariablesButton = this.createPushButton(composite, Messages.CMakeMainTab2_Variables, null);
        argumentVariablesButton.addListener(13, e -> this.handleVariablesButtonSelected(argumentField));
        Label instruction = new Label((Composite)group, 0);
        instruction.setText(Messages.CMakeMainTab2_Note);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        instruction.setLayoutData((Object)gridData);
    }

    private void handleVariablesButtonSelected(TextWithButton textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    protected void createUartComposite(Composite parent) {
        Composite defaultComposite = new Composite(parent, 0);
        this.switchComposites.putIfAbsent(FlashInterface.UART, new ArrayList());
        this.switchComposites.get((Object)FlashInterface.UART).add(defaultComposite);
        defaultComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData defaultCompositeGridData = new GridData(768);
        defaultCompositeGridData.exclude = true;
        this.switchGridDatas.putIfAbsent(FlashInterface.UART, new ArrayList());
        this.switchGridDatas.get((Object)FlashInterface.UART).add(defaultCompositeGridData);
        defaultComposite.setLayout((Layout)layout);
        defaultComposite.setLayoutData((Object)defaultCompositeGridData);
        this.createLocationComponent(defaultComposite);
        this.createWorkDirectoryComponent(defaultComposite);
        GridData locationAndWorkDirGroupData = new GridData(4, 0, true, false);
        this.locationField.getParent().setLayoutData((Object)locationAndWorkDirGroupData);
        this.workDirectoryField.getParent().setLayoutData((Object)locationAndWorkDirGroupData);
        this.uartAgrumentsField = new TextWithButton(parent, 2112);
        this.createArgumentComponent(defaultComposite, this.uartAgrumentsField);
        this.createFlashEncryptionCheckbox(defaultComposite);
        this.createVerticalSpacer(defaultComposite, 1);
    }

    private void createFlashEncryptionCheckbox(Composite parent) {
        Group flashGroup = new Group(parent, 0);
        flashGroup.setText(Messages.CMakeMainTab2_FlashEncryptionGroup);
        flashGroup.setLayout((Layout)new GridLayout(1, false));
        flashGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        this.flashEncryptionCheckbox = new Button((Composite)flashGroup, 32);
        this.flashEncryptionCheckbox.setText(Messages.CMakeMainTab2_FlashEncryptionCheckbox);
        this.flashEncryptionCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Link flashEncryptionNote = new Link((Composite)flashGroup, 64);
        flashEncryptionNote.setText(Messages.CMakeMainTab2_FlashEncryptionNote);
        flashEncryptionNote.addListener(13, e -> {
            boolean bl = Program.launch((String)DOCS_ESPRESSIF_FLASH_ENCRYPTION_HTML);
        });
    }

    protected void createJtagflashComposite(Composite parent) {
        Composite jtagComposite = new Composite(parent, 0);
        this.switchComposites.putIfAbsent(FlashInterface.JTAG, new ArrayList());
        this.switchComposites.get((Object)FlashInterface.JTAG).add(jtagComposite);
        jtagComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData jtagCompositeGridData = new GridData(768);
        jtagCompositeGridData.exclude = true;
        this.switchGridDatas.putIfAbsent(FlashInterface.JTAG, new ArrayList());
        this.switchGridDatas.get((Object)FlashInterface.JTAG).add(jtagCompositeGridData);
        jtagComposite.setLayout((Layout)layout);
        jtagComposite.setLayoutData((Object)jtagCompositeGridData);
        this.jtagArgumentsField = new TextWithButton(parent, 2112);
        this.createArgumentComponent(jtagComposite, this.jtagArgumentsField);
        this.createVerticalSpacer(jtagComposite, 1);
    }

    private Composite createDfuComposite(Composite parent) {
        Composite dfuComposite = new Composite(parent, 0);
        this.switchComposites.putIfAbsent(FlashInterface.DFU, new ArrayList());
        this.switchComposites.get((Object)FlashInterface.DFU).add(dfuComposite);
        dfuComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData dfuCompositeGridData = new GridData(768);
        dfuCompositeGridData.exclude = true;
        this.switchGridDatas.putIfAbsent(FlashInterface.DFU, new ArrayList());
        this.switchGridDatas.get((Object)FlashInterface.DFU).add(dfuCompositeGridData);
        dfuComposite.setLayout((Layout)layout);
        dfuComposite.setLayoutData((Object)dfuCompositeGridData);
        return dfuComposite;
    }

    private void createDfuArgumentField(Composite parent) {
        Composite dfuComposite = this.createDfuComposite(parent);
        this.dfuArgumentsField = new TextWithButton(parent, 2112);
        this.createArgumentComponent(dfuComposite, this.dfuArgumentsField);
        this.createVerticalSpacer(dfuComposite, 1);
    }

    private void createProjectGroup(Composite parent, int colSpan) {
        Group projectGroup = new Group(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projectGroup.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projectGroup.setLayoutData((Object)gd);
        Label fProjLabel = new Label((Composite)projectGroup, 0);
        fProjLabel.setText(LaunchMessages.CMainTab_ProjectColon);
        gd = new GridData();
        gd.horizontalSpan = 2;
        fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text((Composite)projectGroup, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        Button fProjButton = this.createPushButton((Composite)projectGroup, LaunchMessages.Launch_common_Browse_1, null);
        this.fProjText.addModifyListener(evt -> this.updateLaunchConfigurationDialog());
        fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CMakeMainTab2.this.chooseProject();
                CMakeMainTab2.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void chooseProject() {
        try {
            ICProject cProject;
            Object[] projects = CoreModel.getDefault().getCModel().getCProjects();
            CElementLabelProvider labelProvider = new CElementLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle(LaunchMessages.CMainTab_Project_Selection);
            dialog.setMessage(LaunchMessages.CMainTab_Choose_project_to_constrain_search_for_program);
            dialog.setElements(projects);
            String initialProjectName = this.fProjText != null ? this.fProjText.getText().trim() : "";
            ICProject iCProject = cProject = initialProjectName.isEmpty() ? null : CoreModel.getDefault().getCModel().getCProject(this.fProjText.getText());
            if (cProject != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                this.selectedProject = ((ICProject)dialog.getFirstResult()).getProject();
            }
            if (this.fProjText != null && this.selectedProject != null) {
                this.fProjText.setText(this.selectedProject.getName());
            }
        }
        catch (CModelException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private void createJtagFlashButton(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        c.setLayout((Layout)layout);
        Label flashOverComboLabel = new Label(c, 0);
        flashOverComboLabel.setText(Messages.CMakeMainTab2_FlashComboLbl);
        this.flashOverComboButton = new Combo(c, 12);
        this.flashOverComboButton.setItems(FlashInterface.getNames());
        this.flashOverComboButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlashInterface flashInterface = FlashInterface.valueOf(((Combo)e.widget).getText());
                switch (flashInterface) {
                    case UART: {
                        CMakeMainTab2.this.isFlashOverJtag = false;
                        break;
                    }
                    case JTAG: {
                        CMakeMainTab2.this.isFlashOverJtag = true;
                        break;
                    }
                    case DFU: {
                        CMakeMainTab2.this.isFlashOverJtag = false;
                        break;
                    }
                }
                CMakeMainTab2.this.switchUI(flashInterface);
                CMakeMainTab2.this.updateLaunchConfigurationDialog();
            }
        });
        if (!this.isJtagFlashAvailable) {
            Label lbl = new Label(c, 0);
            lbl.setForeground(parent.getDisplay().getSystemColor(8));
            lbl.setText(Messages.CMakeMainTab2_JtagFlashingNotSupportedMsg);
            this.flashOverComboButton.remove(Arrays.asList(this.flashOverComboButton.getItems()).indexOf(FlashInterface.JTAG.name()));
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        this.selectedProject = this.getSelectedProject();
        if (this.selectedProject != null) {
            this.initializeCProject(this.selectedProject, configuration);
        }
        try {
            configuration.doSave();
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private IProject getSelectedProject() {
        ArrayList projectList = new ArrayList(1);
        Display.getDefault().syncExec(() -> {
            IProject project = EclipseUtil.getSelectedProjectInExplorer();
            if (project != null) {
                projectList.add(project);
            }
        });
        try {
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            projectList.addAll(Stream.of(projects).map(ICProject::getProject).collect(Collectors.toList()));
        }
        catch (CModelException e) {
            Logger.log((Exception)((Object)e));
        }
        return !projectList.isEmpty() ? (IProject)projectList.get(0) : null;
    }

    protected void initializeCProject(IProject project, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (project != null && project.exists()) {
            name = project.getName();
            config.setMappedResources(new IResource[]{project});
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null && projDes.getActiveConfiguration() != null) {
                String buildConfigID = projDes.getActiveConfiguration().getId();
                config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
            }
        }
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", name);
    }

    private void switchUI(FlashInterface flashInterface) {
        this.switchGridDatas.values().forEach(list -> list.forEach(gridData -> {
            boolean bl = gridData.exclude = true;
        }));
        this.switchComposites.values().forEach(list -> list.forEach(composite -> composite.setVisible(false)));
        this.switchGridDatas.get((Object)flashInterface).forEach(gridData -> {
            boolean bl = gridData.exclude = false;
        });
        this.switchComposites.get((Object)flashInterface).forEach(composite -> composite.setVisible(true));
        this.mainComposite.requestLayout();
        Composite composite2 = this.mainComposite.getParent();
        if (composite2 instanceof ScrolledComposite) {
            ScrolledComposite sc = (ScrolledComposite)composite2;
            this.mainComposite.setSize(this.mainComposite.computeSize(-1, -1));
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            this.mainComposite.layout(true, true);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String projectName;
        boolean isConfigValid = super.isValid(launchConfig);
        boolean hasProject = false;
        try {
            hasProject = launchConfig.getMappedResources() != null && launchConfig.getMappedResources()[0].getProject().exists();
            String cmakeArgs = launchConfig.getAttribute("cmake.arguments", "");
            if (cmakeArgs.contains("-B")) {
                this.setErrorMessage(Messages.CMakeMainTab2_CmakeArgsDeprecatedBArgMessage);
                return false;
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        if ((projectName = this.fProjText.getText().trim()).length() == 0) {
            this.setErrorMessage(LaunchMessages.CMainTab_Project_not_specified);
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            this.setErrorMessage(LaunchMessages.Launch_common_Project_does_not_exist);
            return false;
        }
        if (!project.isOpen()) {
            this.setErrorMessage(LaunchMessages.CMainTab_Project_must_be_opened);
            return false;
        }
        return isConfigValid && hasProject && this.validateEncoding();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute("DFU", this.flashOverComboButton.getText().contentEquals(FlashInterface.DFU.name()));
            if (this.selectedProject != null) {
                this.initializeCProject(this.selectedProject, wc);
            }
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.fProjText.getText());
            wc.setAttribute("FLASH_OVER_JTAG", this.isFlashOverJtag);
            wc.setAttribute("com.espressif.idf.debug.gdbjtag.openocd.jtagFlashArguments", this.jtagArgumentsField.getText());
            wc.setAttribute("com.espressif.idf.launch.serial.core.serialFlashArguments", this.uartAgrumentsField.getText());
            wc.setAttribute("com.espressif.idf.launch.serial.core.dfuFlashArguments", this.dfuArgumentsField.getText());
            wc.setAttribute("OPEN_SERIAL_MONITOR", this.checkOpenSerialMonitorButton.getSelection());
            if (this.checkOpenSerialMonitorButton.getSelection()) {
                wc.setAttribute("SERIAL_MONITOR_ENCODING", this.fEncodingCombo.getText());
            }
            wc.setAttribute("com.espressif.idf.launch.FLASH_ENCRYPTION_ENABLED", this.flashEncryptionCheckbox.getSelection());
            wc.doSave();
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.updateFlashEncryptionGroup(configuration);
        this.updateStartSerialMonitorGroup(configuration);
        this.updateProjetFromConfig(configuration);
        this.updateFlashOverStatus(configuration);
        this.updateArgumentsWithDefaultFlashCommand(configuration);
        this.switchUI(FlashInterface.values()[this.flashOverComboButton.getSelectionIndex()]);
    }

    private void updateFlashEncryptionGroup(ILaunchConfiguration configuration) {
        boolean isFlashEncryptionEnabled = false;
        try {
            isFlashEncryptionEnabled = configuration.getAttribute("com.espressif.idf.launch.FLASH_ENCRYPTION_ENABLED", false);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        this.flashEncryptionCheckbox.setSelection(isFlashEncryptionEnabled);
    }

    private void updateProjetFromConfig(ILaunchConfiguration configuration) {
        String projectName = "";
        try {
            projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        }
        catch (CoreException ce) {
            Logger.log((Exception)((Object)ce));
        }
        if (!this.fProjText.getText().equals(projectName)) {
            this.fProjText.setText(projectName);
        }
    }

    private void updateFlashOverStatus(ILaunchConfiguration configuration) {
        boolean isDfu = false;
        try {
            isDfu = configuration.getAttribute("DFU", false);
            if (isDfu) {
                int dfuIndex = Arrays.asList(this.flashOverComboButton.getItems()).indexOf(FlashInterface.DFU.name());
                this.flashOverComboButton.select(dfuIndex);
            } else {
                int uartIndex = Arrays.asList(this.flashOverComboButton.getItems()).indexOf(FlashInterface.UART.name());
                this.flashOverComboButton.select(uartIndex);
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        if (!this.isJtagFlashAvailable) {
            return;
        }
        try {
            this.isFlashOverJtag = configuration.getAttribute("FLASH_OVER_JTAG", this.isFlashOverJtag);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        if (this.isFlashOverJtag && !isDfu) {
            this.flashOverComboButton.select(Arrays.asList(this.flashOverComboButton.getItems()).indexOf(FlashInterface.JTAG.name()));
        }
    }

    private void updateArgumentsWithDefaultFlashCommand(ILaunchConfiguration configuration) {
        try {
            String uartFlashCommand = configuration.getAttribute("com.espressif.idf.launch.serial.core.serialFlashArguments", "");
            this.uartAgrumentsField.setText(uartFlashCommand.isBlank() ? ESPFlashUtil.getParseableEspFlashCommand((String)"${serial_port}") : uartFlashCommand);
            this.jtagArgumentsField.setText(configuration.getAttribute("com.espressif.idf.debug.gdbjtag.openocd.jtagFlashArguments", DEFAULT_JTAG_CONFIG_OPTIONS));
            this.dfuArgumentsField.setText(configuration.getAttribute("com.espressif.idf.launch.serial.core.dfuFlashArguments", DfuCommandsUtil.getDfuFlashCommand()));
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    protected void updateLocation(ILaunchConfiguration configuration) {
        super.updateLocation(configuration);
        try {
            String location = configuration.getAttribute("org.eclipse.cdt.launch.ATTR_LOCATION", "");
            if (StringUtil.isEmpty((String)location)) {
                location = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(IDFDynamicVariables.IDF_PYTHON_ENV_PATH.name(), null);
            }
            this.locationField.setText(location);
        }
        catch (Exception e) {
            Logger.log((Exception)e);
        }
    }

    protected void updateWorkingDirectory(ILaunchConfiguration configuration) {
        super.updateWorkingDirectory(configuration);
        if (this.workDirectoryField.getText().isEmpty()) {
            try {
                if (configuration.getMappedResources() == null) {
                    return;
                }
                URI locationUri = configuration.getMappedResources()[0].getProject().getLocationURI();
                if (locationUri != null) {
                    File workingDir = new File(configuration.getMappedResources()[0].getProject().getLocationURI());
                    this.workDirectoryField.setText(this.newVariableExpression("workspace_loc", workingDir.getName()));
                }
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
            }
        }
    }

    private void createOpenSerialMonitorGroup(final Composite mainComposite) {
        Group group = SWTFactory.createGroup((Composite)mainComposite, (String)Messages.CMakeMainTab2_SerialMonitorGroup, (int)2, (int)1, (int)768);
        this.checkOpenSerialMonitorButton = new Button((Composite)group, 32);
        this.checkOpenSerialMonitorButton.setText(Messages.CMakeMainTab2_SerialMonitorBtn);
        GridData gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 2;
        this.checkOpenSerialMonitorButton.setLayoutData((Object)gd);
        final Label encodingLbl = new Label((Composite)group, 0);
        encodingLbl.setText(Messages.CMakeMainTab2_SerialMonitorEncodingLbl);
        this.fEncodingCombo = new Combo((Composite)group, 8);
        this.fEncodingCombo.setLayoutData((Object)new GridData(1));
        List allEncodings = IDEEncoding.getIDEEncodings();
        String[] encodingArray = allEncodings.toArray(new String[0]);
        this.fEncodingCombo.setItems(encodingArray);
        if (encodingArray.length > 0) {
            this.fEncodingCombo.select(0);
        }
        this.fEncodingCombo.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        this.checkOpenSerialMonitorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeMainTab2.this.fEncodingCombo.setVisible(CMakeMainTab2.this.checkOpenSerialMonitorButton.getSelection());
                GridData data = (GridData)CMakeMainTab2.this.fEncodingCombo.getLayoutData();
                data.exclude = !CMakeMainTab2.this.fEncodingCombo.getVisible();
                encodingLbl.setVisible(CMakeMainTab2.this.checkOpenSerialMonitorButton.getSelection());
                data = (GridData)encodingLbl.getLayoutData();
                data.exclude = !encodingLbl.getVisible();
                mainComposite.layout(true, true);
                CMakeMainTab2.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void updateStartSerialMonitorGroup(ILaunchConfiguration configuration) {
        try {
            this.checkOpenSerialMonitorButton.setSelection(configuration.getAttribute("OPEN_SERIAL_MONITOR", true));
            this.checkOpenSerialMonitorButton.notifyListeners(13, null);
            int encodingIndex = this.fEncodingCombo.indexOf(configuration.getAttribute("SERIAL_MONITOR_ENCODING", ""));
            encodingIndex = encodingIndex == -1 ? 0 : encodingIndex;
            this.fEncodingCombo.select(encodingIndex);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private boolean validateEncoding() {
        if (this.checkOpenSerialMonitorButton.getSelection() && this.fEncodingCombo.getSelectionIndex() == -1 && !this.isValidEncoding(this.fEncodingCombo.getText().trim())) {
            this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_15);
            return false;
        }
        return true;
    }

    private boolean isValidEncoding(String enc) {
        try {
            return Charset.isSupported(enc);
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
    }

    private void initializeFromDefaults() {
        this.uartAgrumentsField.setText(ESPFlashUtil.getParseableEspFlashCommand((String)"${serial_port}"));
        this.jtagArgumentsField.setText(DEFAULT_JTAG_CONFIG_OPTIONS);
        this.dfuArgumentsField.setText(DfuCommandsUtil.getDfuFlashCommand());
    }

    public static enum FlashInterface {
        UART,
        JTAG,
        DFU;


        public static String[] getNames() {
            return (String[])Arrays.stream(FlashInterface.values()).map(Enum::name).toArray(String[]::new);
        }
    }
}

