/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.ui;

import com.espressif.idf.sdk.config.core.server.CommandType;
import com.espressif.idf.sdk.config.core.server.ConfigServerManager;
import com.espressif.idf.sdk.config.core.server.JsonConfigServer;
import com.espressif.idf.sdk.config.ui.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.json.simple.JSONObject;

public class LoadSdkConfigHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource resource = LoadSdkConfigHandler.getSelectedResource((IEvaluationContext)event.getApplicationContext());
        if (resource == null) {
            return resource;
        }
        if (!(resource instanceof IFile)) {
            return resource;
        }
        IProject project = resource.getProject();
        IFile file = (IFile)resource;
        try {
            JsonConfigServer server = ConfigServerManager.INSTANCE.getServer(project, file);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"version", (Object)2);
            jsonObject.put((Object)"load", null);
            String command = jsonObject.toJSONString();
            server.execute(command, CommandType.LOAD);
        }
        catch (Exception e) {
            throw new ExecutionException(Messages.LoadSdkConfigHandler_ErrorLoadingJsonConfigServer, (Throwable)e);
        }
        return null;
    }

    public static IResource getSelectedResource(IEvaluationContext evaluationContext) {
        if (evaluationContext == null) {
            return null;
        }
        Object variable = evaluationContext.getVariable("selection");
        if (variable instanceof IStructuredSelection) {
            IResource resource;
            Object selectedObject = ((IStructuredSelection)variable).getFirstElement();
            if (selectedObject instanceof IAdaptable && (resource = (IResource)((IAdaptable)selectedObject).getAdapter(IResource.class)) != null) {
                return resource;
            }
        } else {
            IEditorInput editorInput;
            variable = evaluationContext.getVariable("activeEditor");
            if (variable instanceof IEditorPart && (editorInput = ((IEditorPart)variable).getEditorInput()) instanceof IFileEditorInput) {
                return ((IFileEditorInput)editorInput).getFile();
            }
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

