/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.controls.themes;

import com.espressif.idf.terminal.connector.controls.themes.ITerminalTheme;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.terminal.model.TerminalColor;

public class CustomTheme
implements ITerminalTheme {
    private final String id;
    private final String label;
    protected final Map<TerminalColor, String> colorMap = new EnumMap<TerminalColor, String>(TerminalColor.class);

    public CustomTheme(String id, String label) {
        this.id = id;
        this.label = label;
        this.loadDefaults();
        this.configure();
    }

    protected void configure() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    protected void set(TerminalColor color, int r, int g, int b) {
        this.colorMap.put(color, r + "," + g + "," + b);
    }

    @Override
    public void apply(IPreferenceStore store) {
        for (Map.Entry<TerminalColor, String> entry : this.colorMap.entrySet()) {
            store.setValue(entry.getKey().name(), entry.getValue());
        }
    }

    private void loadDefaults() {
        this.set(TerminalColor.BLACK, 0, 0, 0);
        this.set(TerminalColor.RED, 205, 0, 0);
        this.set(TerminalColor.GREEN, 0, 205, 0);
        this.set(TerminalColor.YELLOW, 205, 205, 0);
        this.set(TerminalColor.BLUE, 0, 0, 238);
        this.set(TerminalColor.MAGENTA, 205, 0, 205);
        this.set(TerminalColor.CYAN, 0, 205, 205);
        this.set(TerminalColor.WHITE, 229, 229, 229);
        this.set(TerminalColor.BRIGHT_BLACK, 0, 0, 0);
        this.set(TerminalColor.BRIGHT_RED, 255, 0, 0);
        this.set(TerminalColor.BRIGHT_GREEN, 0, 255, 0);
        this.set(TerminalColor.BRIGHT_YELLOW, 255, 255, 0);
        this.set(TerminalColor.BRIGHT_BLUE, 92, 92, 255);
        this.set(TerminalColor.BRIGHT_MAGENTA, 255, 0, 255);
        this.set(TerminalColor.BRIGHT_CYAN, 0, 255, 255);
        this.set(TerminalColor.BRIGHT_WHITE, 255, 255, 255);
    }
}

