/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.controls;

import com.espressif.idf.core.IDFProjectNature;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.terminal.connector.controls.Messages;
import com.espressif.idf.terminal.connector.controls.themes.EspressifDarkTheme;
import com.espressif.idf.terminal.connector.controls.themes.EspressifLightTheme;
import com.espressif.idf.terminal.connector.controls.themes.ITerminalTheme;
import com.espressif.idf.terminal.connector.controls.themes.PowerShellTheme;
import com.espressif.idf.terminal.connector.controls.themes.ResetTheme;
import com.espressif.idf.ui.EclipseUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.terminal.view.ui.launcher.AbstractExtendedConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class IDFConsoleWizardConfigurationPanel
extends AbstractExtendedConfigurationPanel {
    private static final String PREF_THEME_SELECTION = "IDF_CONSOLE_THEME_SELECTION";
    private static final String TERMINAL_PREF_NODE = "org.eclipse.terminal.control";
    private Combo projectCombo;
    private final List<ITerminalTheme> themes = new ArrayList<ITerminalTheme>();
    private final List<Button> themeButtons = new ArrayList<Button>();

    public IDFConsoleWizardConfigurationPanel(IConfigurationPanelContainer container) {
        super(container);
        this.themes.add(new ResetTheme());
        this.themes.add(new EspressifLightTheme());
        this.themes.add(new EspressifDarkTheme());
        this.themes.add(new PowerShellTheme());
    }

    public void setupPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createProjectCombo(panel);
        this.createEncodingUI(panel, false);
        this.createThemeUI(panel);
        if ("macosx".equals(Platform.getOS()) || "win32".equals(Platform.getOS())) {
            this.setEncoding("UTF-8");
        } else {
            String encoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
            if (encoding != null && !"".equals(encoding)) {
                this.setEncoding(encoding);
            }
        }
        Label label = new Label(panel, 256);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 300;
        layoutData.heightHint = 80;
        label.setLayoutData((Object)layoutData);
        this.setControl(panel);
    }

    private void createThemeUI(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.IDFConsoleWizardConfigurationPanel_TerminalColorPresetsLbl);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.themeButtons.clear();
        for (ITerminalTheme theme : this.themes) {
            Button btn = new Button((Composite)group, 16);
            btn.setText(theme.getLabel());
            btn.setData((Object)theme);
            this.themeButtons.add(btn);
        }
        Label noteLabel = new Label((Composite)group, 64);
        noteLabel.setText(Messages.IDFConsoleWizardConfigurationPanel_TerminalColorPresetsNote);
        noteLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont"));
        GridData noteData = new GridData(4, 0x1000000, true, false);
        noteData.verticalIndent = 5;
        noteLabel.setLayoutData((Object)noteData);
    }

    public void extractData(Map<String, Object> data) {
        IProject p;
        data.put("tm.terminal.connector.id", "com.espressif.idf.terminal.connector.espidfConnector");
        data.put("encoding", this.getEncoding());
        if (this.projectCombo != null && !this.projectCombo.isDisposed() && !this.projectCombo.getText().isEmpty() && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectCombo.getText())) != null && p.exists() && p.getLocation() != null) {
            data.put("process.working_dir", p.getLocation().toOSString());
            data.put("title", p.getName());
        }
        for (Button btn : this.themeButtons) {
            if (btn == null || btn.isDisposed() || !btn.getSelection()) continue;
            ITerminalTheme strategy = (ITerminalTheme)btn.getData();
            if (strategy == null) break;
            this.applyThemeStrategy(strategy);
            break;
        }
    }

    private void applyThemeStrategy(ITerminalTheme theme) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, TERMINAL_PREF_NODE);
        theme.apply((IPreferenceStore)store);
        if (store instanceof ScopedPreferenceStore) {
            ScopedPreferenceStore preferenceStore = store;
            try {
                preferenceStore.save();
            }
            catch (Exception ex) {
                Logger.log((Exception)ex);
            }
        }
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        this.doSaveEncodingsWidgetValues(settings, idPrefix);
        if (settings != null) {
            for (Button btn : this.themeButtons) {
                if (!btn.getSelection()) continue;
                ITerminalTheme theme = (ITerminalTheme)btn.getData();
                settings.put(PREF_THEME_SELECTION, theme.getId());
                break;
            }
        }
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        this.doRestoreEncodingsWidgetValues(settings, idPrefix);
        if (settings != null) {
            String savedId = settings.get(PREF_THEME_SELECTION);
            boolean found = false;
            for (Button btn : this.themeButtons) {
                ITerminalTheme theme = (ITerminalTheme)btn.getData();
                if (theme.getId().equals(savedId)) {
                    btn.setSelection(true);
                    found = true;
                    continue;
                }
                btn.setSelection(false);
            }
            if (!found && !this.themeButtons.isEmpty()) {
                this.themeButtons.get(0).setSelection(true);
            }
        } else if (!this.themeButtons.isEmpty()) {
            this.themeButtons.get(0).setSelection(true);
        }
    }

    private void createProjectCombo(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label projectLabel = new Label(panel, 0);
        projectLabel.setText(Messages.IDFConsoleWizardConfigurationPanel_IDFConsoleWizardConfigurationPanel_ProjectLabel);
        this.projectCombo = new Combo(panel, 8);
        this.projectCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            try {
                if (project2.hasNature(IDFProjectNature.ID)) {
                    this.projectCombo.add(project2.getName());
                }
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
            }
            ++n2;
        }
        Optional<IProject> optProject = Optional.ofNullable(EclipseUtil.getSelectedIDFProjectInExplorer());
        optProject.ifPresentOrElse(project -> this.projectCombo.setText(project.getName()), () -> {
            if (this.projectCombo.getItemCount() > 0) {
                this.projectCombo.select(0);
            }
        });
    }

    public void setupData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        String value = (String)data.get("encoding");
        if (value != null) {
            this.setEncoding(value);
        }
    }

    protected void fillSettingsForHost(String host) {
    }

    protected void saveSettingsForHost(boolean add) {
    }

    public boolean isValid() {
        return true;
    }

    protected String getHostFromSettings() {
        return null;
    }

    public boolean isWithHostList() {
        return false;
    }
}

