/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.launch.serial.internal;

import com.espressif.idf.launch.serial.internal.Activator;
import com.espressif.idf.launch.serial.internal.Messages;
import com.espressif.idf.terminal.connector.serial.connector.SerialPortHandler;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.TargetedLaunch;

public class SerialFlashLaunch
extends TargetedLaunch {
    private SerialPortHandler serialPort;
    private boolean wasOpen;

    public SerialFlashLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator, ILaunchTarget target) {
        super(launchConfiguration, mode, target, locator);
        if (target != null) {
            String serialPortName = target.getAttribute("com.espressif.idf.launch.serial.core.serialPort", "");
            this.serialPort = !serialPortName.isEmpty() ? SerialPortHandler.get((String)serialPortName) : null;
        }
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void start() {
        if (this.serialPort != null) {
            this.wasOpen = this.serialPort.isOpen();
            if (this.wasOpen) {
                try {
                    this.serialPort.pause();
                }
                catch (IOException e) {
                    Activator.log((IStatus)new Status(4, "com.espressif.idf.launch.serial.core", Messages.SerialFlashLaunch_Pause, (Throwable)e));
                }
            }
        } else {
            this.wasOpen = false;
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        super.handleDebugEvents(events);
        if (this.isTerminated() && this.wasOpen) {
            try {
                this.serialPort.resume();
            }
            catch (IOException e) {
                Activator.log((IStatus)new Status(4, "com.espressif.idf.launch.serial.core", Messages.SerialFlashLaunch_Resume, (Throwable)e));
            }
            this.wasOpen = false;
        }
    }
}

