/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.wizard;

import com.espressif.idf.ui.wizard.Messages;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.WorkbenchJob;

public class ImportIDFProjectWizardPage
extends WizardPage {
    private Text projectName;
    private Text location;
    private IWorkspaceRoot root;
    boolean projectNameSetByUser;
    private Button copyCheckbox;
    private boolean copyProject;

    protected ImportIDFProjectWizardPage() {
        super(Messages.ImportIDFProjectWizardPage_0);
        this.setTitle(Messages.ImportIDFProjectWizardPage_1);
        this.setDescription(Messages.ImportIDFProjectWizardPage_2);
        this.root = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addProjectNameSelector(comp);
        this.addSourceSelector(comp);
        this.setControl((Control)comp);
        this.createOptions(comp);
    }

    public void createOptions(Composite comp) {
        this.copyCheckbox = new Button(comp, 32);
        this.copyCheckbox.setText(Messages.ImportIDFProjectWizardPage_CopyIntoWorkspace);
        this.copyCheckbox.setLayoutData((Object)new GridData(768));
        this.copyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportIDFProjectWizardPage.this.copyProject = ImportIDFProjectWizardPage.this.copyCheckbox.getSelection();
            }
        });
    }

    public void addProjectNameSelector(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.ImportIDFProjectWizardPage_3);
        this.projectName = new Text((Composite)group, 2048);
        this.projectName.setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportIDFProjectWizardPage.this.validatePage();
                if (ImportIDFProjectWizardPage.this.getProjectName().isEmpty()) {
                    ImportIDFProjectWizardPage.this.projectNameSetByUser = false;
                }
            }
        });
        this.projectName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ImportIDFProjectWizardPage.this.projectNameSetByUser = true;
            }
        });
    }

    protected void validatePage() {
        String msg = null;
        boolean complete = true;
        String name = this.getProjectName();
        if (name.isEmpty()) {
            complete = false;
        } else {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 4);
            if (!status.isOK()) {
                msg = status.getMessage();
            } else {
                IProject project = this.root.getProject(name);
                if (project.exists()) {
                    msg = Messages.ImportIDFProjectWizardPage_4;
                }
            }
        }
        if (msg == null) {
            String loc = this.getLocation();
            if (loc.isEmpty()) {
                complete = false;
            } else {
                final File file = new File(loc);
                if (file.isDirectory()) {
                    if (!file.canWrite()) {
                        msg = Messages.ImportIDFProjectWizardPage_5;
                    } else if (!this.projectNameSetByUser && !name.equals(file.getName())) {
                        WorkbenchJob wjob = new WorkbenchJob("update project name"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (!ImportIDFProjectWizardPage.this.projectName.isDisposed()) {
                                    ImportIDFProjectWizardPage.this.projectName.setText(file.getName());
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        wjob.setSystem(true);
                        wjob.schedule();
                    }
                } else {
                    msg = Messages.ImportIDFProjectWizardPage_6;
                }
            }
        }
        this.setErrorMessage(msg);
        this.setPageComplete(msg == null && complete);
    }

    @Deprecated
    public void validateProjectName() {
        this.validatePage();
    }

    public void addSourceSelector(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.ImportIDFProjectWizardPage_7);
        this.location = new Text((Composite)group, 2048);
        this.location.setLayoutData((Object)new GridData(4, 4, true, true));
        this.location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportIDFProjectWizardPage.this.validatePage();
            }
        });
        this.validatePage();
        Button browse = new Button((Composite)group, 0);
        browse.setLayoutData((Object)new GridData(4, 4, false, true));
        browse.setText(Messages.ImportIDFProjectWizardPage_8);
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ImportIDFProjectWizardPage.this.location.getShell());
                dialog.setMessage(Messages.ImportIDFProjectWizardPage_9);
                String dir = dialog.open();
                if (dir != null) {
                    ImportIDFProjectWizardPage.this.location.setText(dir);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Deprecated
    void validateSource() {
        this.validatePage();
    }

    public String getProjectName() {
        return this.projectName.getText().trim();
    }

    public String getLocation() {
        return this.location.getText().trim();
    }

    public boolean canCopyIntoWorkspace() {
        return this.copyProject;
    }
}

