/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.update;

import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.UIPlugin;
import com.espressif.idf.ui.update.Messages;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class DirectorySelectionDialog
extends TitleAreaDialog {
    private Text text;
    private String idfDirPath;
    private String pythonExecutablePath;
    private Map<String, String> pythonVersions;
    private String gitPath;
    private Text gitLocationtext;
    private Text pythonLocationtext;
    private String commandId;
    private static final String pythonPathNodeKey = "PYTHON_EXECUTABLE";
    private static final String gitPathNodeKey = "GIT_EXECUTABLE";

    protected DirectorySelectionDialog(Shell parentShell, String commandId, String pythonExecutablePath, Map<String, String> pythonVersions, String idfPath, String gitExecutablePath) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.pythonExecutablePath = this.getPythonPreferenceOrDefault(pythonExecutablePath);
        this.pythonVersions = pythonVersions;
        this.idfDirPath = idfPath;
        this.gitPath = this.getGitPreferenceOrDefault(gitExecutablePath);
        this.commandId = commandId;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.DirectorySelectionDialog_InstallTools);
        this.setTitle(Messages.DirectorySelectionDialog_IDFToolsInstallationDialog);
        this.setTitleImage(UIPlugin.getImage("icons/espressif_logo.png"));
        this.setMessage(Messages.DirectorySelectionDialog_ProvideIDFDirectory);
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        composite.setLayout((Layout)topLayout);
        composite.setLayoutData((Object)gd);
        new Label(composite, 0).setText(Messages.DirectorySelectionDialog_IDFDirLabel);
        this.text = new Text(composite, 2048);
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.text.setLayoutData((Object)data);
        this.text.setText(this.idfDirPath != null ? this.idfDirPath : "");
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DirectorySelectionDialog.this.validate();
            }
        });
        Button button = new Button(composite, 8);
        button.setText(Messages.DirectorySelectionDialog_Browse);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(Display.getDefault().getActiveShell());
                dlg.setFilterPath(DirectorySelectionDialog.this.text.getText());
                dlg.setText(Messages.DirectorySelectionDialog_IDFDirLabel);
                dlg.setMessage(Messages.DirectorySelectionDialog_SelectIDFDirMessage);
                String dir = dlg.open();
                if (dir != null) {
                    DirectorySelectionDialog.this.text.setText(dir);
                }
            }
        });
        new Label(composite, 0).setText(Messages.DirectorySelectionDialog_GitExeLocation);
        this.gitLocationtext = new Text(composite, 2048);
        data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.gitLocationtext.setLayoutData((Object)data);
        this.gitLocationtext.setText(this.gitPath != null ? this.gitPath : "");
        this.gitLocationtext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DirectorySelectionDialog.this.validate();
            }
        });
        Button gitBrowseBtn = new Button(composite, 8);
        gitBrowseBtn.setText(Messages.DirectorySelectionDialog_Browse);
        gitBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(Display.getDefault().getActiveShell());
                dlg.setText(Messages.DirectorySelectionDialog_GitExecutableLocation);
                String dir = dlg.open();
                if (dir != null) {
                    DirectorySelectionDialog.this.gitLocationtext.setText(dir);
                }
            }
        });
        this.addPythonVersionSelectionControls(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void addPythonVersionSelectionControls(Composite composite) {
        new Label(composite, 0).setText(Messages.DirectorySelectionDialog_PyExeLocation);
        this.pythonLocationtext = new Text(composite, 2048);
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.pythonLocationtext.setLayoutData((Object)data);
        this.pythonLocationtext.setText(this.pythonExecutablePath != null ? this.pythonExecutablePath : "");
        this.pythonLocationtext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DirectorySelectionDialog.this.validate();
            }
        });
        Button pyBrowseBtn = new Button(composite, 8);
        pyBrowseBtn.setText(Messages.DirectorySelectionDialog_Browse);
        pyBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(Display.getDefault().getActiveShell());
                dlg.setText(Messages.DirectorySelectionDialog_PyExecutableLocation);
                String pythonLocationPathString = dlg.open();
                if (pythonLocationPathString != null) {
                    DirectorySelectionDialog.this.pythonLocationtext.setText(pythonLocationPathString);
                }
            }
        });
    }

    protected void validate() {
        this.idfDirPath = this.text.getText();
        this.pythonExecutablePath = this.pythonLocationtext.getText();
        this.gitPath = this.gitLocationtext.getText();
        boolean isValidPythonPath = this.validatePythonExecutable(this.pythonExecutablePath);
        if (!isValidPythonPath) {
            this.setErrorMessage(Messages.DirectorySelectionDialog_InvalidPythonPath);
            this.getButton(0).setEnabled(false);
        } else if (StringUtil.isEmpty((String)this.pythonExecutablePath) || StringUtil.isEmpty((String)this.gitPath) || StringUtil.isEmpty((String)this.idfDirPath)) {
            this.setErrorMessage(Messages.DirectorySelectionDialog_CantbeEmpty);
            this.getButton(0).setEnabled(false);
        } else {
            this.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
        }
    }

    private void saveExecutablePreferences() {
        Preferences scopedPreferenceStore = this.getPreferences();
        scopedPreferenceStore.put(pythonPathNodeKey, this.pythonExecutablePath);
        scopedPreferenceStore.put(gitPathNodeKey, this.gitPath);
        try {
            scopedPreferenceStore.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private String getPythonPreferenceOrDefault(String pythonExecutablePath) {
        return this.getPreferences().get(pythonPathNodeKey, pythonExecutablePath);
    }

    private String getGitPreferenceOrDefault(String gitExecutablePath) {
        return this.getPreferences().get(gitPathNodeKey, gitExecutablePath);
    }

    public String getIDFDirectory() {
        return this.idfDirPath;
    }

    public String getPythonExecutable() {
        return this.pythonExecutablePath;
    }

    public String getGitExecutable() {
        return this.gitPath;
    }

    protected void okPressed() {
        this.idfDirPath = this.text.getText();
        this.pythonExecutablePath = this.pythonLocationtext.getText();
        this.gitPath = this.gitLocationtext.getText();
        super.okPressed();
        this.saveExecutablePreferences();
    }

    public void create() {
        super.create();
        if (this.commandId != null && this.commandId.equals("com.espressif.idf.ui.command.install")) {
            this.getButton(0).setText(Messages.DirectorySelectionDialog_InstallTools);
            this.validate();
        } else {
            this.getButton(0).setText(Messages.DirectorySelectionDialog_CheckTools);
        }
    }

    private Preferences getPreferences() {
        return ConfigurationScope.INSTANCE.getNode("com.espressif.idf.ui").node("preference");
    }

    private boolean validatePythonExecutable(String path) {
        try {
            Process process = new ProcessBuilder(path, "--version").start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String output = reader.readLine();
            int exitCode = process.waitFor();
            return exitCode == 0 && output.startsWith("Python");
        }
        catch (Exception e) {
            return false;
        }
    }
}

