/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing.heaptracing;

import com.espressif.idf.ui.tracing.DetailsVO;
import com.espressif.idf.ui.tracing.TracingJsonParser;
import com.espressif.idf.ui.tracing.TracingViewerFactory;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class HeapTracingTreeViewer
extends XViewer {
    private Button filterMemoryLeaksChkBtn;
    private List<DetailsVO> detailsVOs;
    private List<DetailsVO> memoryLeakVOs;
    private TracingJsonParser tracingJsonParser;
    private Integer[] eventIdsDisplayed;

    public HeapTracingTreeViewer(Composite parent, int style, TracingJsonParser tracingJsonParser, Integer[] eventIdsDisplayed, TracingViewerFactory tracingViewerFactory) {
        super(parent, style, (IXViewerFactory)tracingViewerFactory, true, true);
        this.tracingJsonParser = tracingJsonParser;
        this.eventIdsDisplayed = eventIdsDisplayed;
        this.detailsVOs = tracingJsonParser.getDetailsVOs(Arrays.asList(eventIdsDisplayed));
        this.memoryLeakVOs = this.detailsVOs.stream().filter(details -> details.isMemoryLeak()).collect(Collectors.toList());
    }

    protected void createSupportWidgets(Composite parent) {
        super.createSupportWidgets(parent);
        this.setFilterMemoryLeaksChkBtn(new Button(parent, 32));
        this.getFilterMemoryLeaksChkBtn().setText("View Possible Memory Leaks");
        this.getFilterMemoryLeaksChkBtn().setLayoutData((Object)new GridData(4, 0, true, false));
        this.getFilterMemoryLeaksChkBtn().addSelectionListener((SelectionListener)new FilterMemoryLeakSelectionListener());
    }

    public void loadInputForXViewer() {
        this.setInputXViewer(this.detailsVOs);
    }

    public Button getFilterMemoryLeaksChkBtn() {
        return this.filterMemoryLeaksChkBtn;
    }

    public void setFilterMemoryLeaksChkBtn(Button filterMemoryLeaksChkBtn) {
        this.filterMemoryLeaksChkBtn = filterMemoryLeaksChkBtn;
    }

    public int getRowIndex(ViewerCell cell) {
        DetailsVO row = (DetailsVO)cell.getElement();
        int result = 0;
        if (this.getFilterMemoryLeaksChkBtn().getSelection()) {
            for (DetailsVO details : this.memoryLeakVOs) {
                if (details.getEventsVO().getTimestampOfEvent() == row.getEventsVO().getTimestampOfEvent()) {
                    return result;
                }
                ++result;
            }
        } else {
            for (DetailsVO details : this.detailsVOs) {
                if (details.getEventsVO().getTimestampOfEvent() == row.getEventsVO().getTimestampOfEvent()) {
                    return result;
                }
                ++result;
            }
        }
        return result;
    }

    private class FilterMemoryLeakSelectionListener
    extends SelectionAdapter {
        private FilterMemoryLeakSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean selected = HeapTracingTreeViewer.this.getFilterMemoryLeaksChkBtn().getSelection();
            if (selected) {
                HeapTracingTreeViewer.this.setInputXViewer(HeapTracingTreeViewer.this.memoryLeakVOs);
            } else {
                HeapTracingTreeViewer.this.setInputXViewer(HeapTracingTreeViewer.this.detailsVOs);
            }
        }
    }
}

