/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.tracing.AddressInfoVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public class TracingCallerAddressDecoder {
    private String elfFilePath;
    private IProject project;

    public TracingCallerAddressDecoder(String elfFilePath, IProject project) {
        this.elfFilePath = elfFilePath;
        this.project = project;
    }

    public Map<String, AddressInfoVO> decodeCallerAddresses(List<String> callerAddresses) {
        if (callerAddresses == null || callerAddresses.size() == 0) {
            return null;
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IDFUtil.getXtensaToolchainExecutableAddr2LinePath((IProject)this.project));
        commands.add("-e");
        commands.add(this.elfFilePath);
        commands.addAll(callerAddresses);
        commands.add("-f");
        Map envMap = new IDFEnvironmentVariables().getSystemEnvMap();
        String decodedAddress = this.runCommand(commands, new Path(this.project.getLocation().toOSString()), envMap);
        return this.getListOfAddresses(decodedAddress, callerAddresses);
    }

    private Map<String, AddressInfoVO> getListOfAddresses(String decodedAddress, List<String> callerAddresses) {
        String[] addresses = decodedAddress.split(System.lineSeparator());
        Pattern removeAfterSpacePattern = Pattern.compile("^(\\S+)");
        HashMap<String, AddressInfoVO> callersMap = new HashMap<String, AddressInfoVO>();
        int callersIndex = 0;
        int i = 0;
        while (i < addresses.length) {
            if (!callersMap.containsKey(callerAddresses.get(callersIndex))) {
                String functionName = addresses[i];
                int index = addresses[i + 1].indexOf(":", 2);
                String fullFilePath = addresses[i + 1].substring(0, index);
                Path path = new Path(fullFilePath);
                IFile file = this.project.getFile((IPath)path);
                Matcher lineNumberMatcher = removeAfterSpacePattern.matcher(addresses[i + 1].substring(index + 1, addresses[i + 1].length()));
                int lineNumber = 1;
                if (lineNumberMatcher.find()) {
                    lineNumber = Integer.parseInt(lineNumberMatcher.group(0));
                }
                callersMap.put(callerAddresses.get(callersIndex), new AddressInfoVO(file, lineNumber, functionName, callerAddresses.get(callersIndex), fullFilePath));
            }
            i += 2;
            ++callersIndex;
        }
        return callersMap;
    }

    private String runCommand(List<String> arguments, Path workDir, Map<String, String> env) {
        String exportCmdOp = "";
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)workDir, env);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Status can't be null", null));
                return IDFCorePlugin.errorStatus((String)"Status can't be null", null).toString();
            }
            exportCmdOp = status.getMessage();
            Logger.log((String)exportCmdOp);
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
        }
        return exportCmdOp;
    }
}

