/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tools;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.DownloadListener;
import com.espressif.idf.core.tools.EimIdfConfiguratinParser;
import com.espressif.idf.core.tools.EimLoader;
import com.espressif.idf.core.tools.ToolInitializer;
import com.espressif.idf.core.tools.exceptions.EimVersionMismatchException;
import com.espressif.idf.core.tools.vo.EimJson;
import com.espressif.idf.ui.handlers.EclipseHandler;
import com.espressif.idf.ui.tools.manager.EimEditorInput;
import com.espressif.idf.ui.tools.manager.pages.ESPIDFMainTablePage;
import java.io.IOException;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.ide.IDE;
import org.osgi.service.prefs.Preferences;

public class EimButtonLaunchListener
extends SelectionAdapter {
    private ESPIDFMainTablePage espidfMainTablePage;
    private Display display;
    private Preferences preferences;
    private ToolInitializer toolInitializer;
    private IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
    private MessageConsoleStream standardConsoleStream;
    private MessageConsoleStream errorConsoleStream;
    private EimLoader eimLoader;

    public EimButtonLaunchListener(ESPIDFMainTablePage espidfMainTablePage, Display display, MessageConsoleStream standardConsoleStream, MessageConsoleStream errorConsoleStream) {
        this.espidfMainTablePage = espidfMainTablePage;
        this.display = display;
        this.standardConsoleStream = standardConsoleStream;
        this.errorConsoleStream = errorConsoleStream;
        this.preferences = InstanceScope.INSTANCE.getNode("com.espressif.idf.ui");
        this.toolInitializer = new ToolInitializer(this.preferences);
        this.eimLoader = new EimLoader((DownloadListener)new EimDownlaodListener(), standardConsoleStream, errorConsoleStream, display);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (!this.toolInitializer.isEimInstalled()) {
            Job downloadJob = new Job("Download and Launch EIM"){

                protected IStatus run(IProgressMonitor monitor) {
                    EimButtonLaunchListener.this.eimLoader.downloadEim(monitor);
                    return Status.OK_STATUS;
                }
            };
            downloadJob.setUser(true);
            downloadJob.schedule();
        } else {
            try {
                Process process = this.eimLoader.launchEim(this.idfEnvironmentVariables.getEnvValue("EIM_PATH"));
                this.eimLoader.waitForEimClosure(process, this::refreshAfterEimClose);
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
    }

    private void refreshAfterEimClose() {
        this.display.asyncExec(() -> {
            try {
                this.launchEspIdfManager();
                this.standardConsoleStream.write("Refreshing UI after EIM closed...\n");
                this.espidfMainTablePage.refreshEditorUI();
                this.espidfMainTablePage.setupInitialEspIdf();
            }
            catch (IOException | PartInitException e) {
                Logger.log((Exception)e);
            }
        });
    }

    private void launchEspIdfManager() throws PartInitException {
        Display.getDefault().asyncExec(() -> {
            block3: {
                IWorkbenchWindow activeww = EclipseHandler.getActiveWorkbenchWindow();
                if (activeww == null || activeww.getActivePage() == null) {
                    Logger.log((String)"Cannot open ESP-IDF Manager. No active workbench window or active page.");
                    return;
                }
                try {
                    EimIdfConfiguratinParser eimIdfConfiguratinParser = new EimIdfConfiguratinParser();
                    EimJson eimJson = eimIdfConfiguratinParser.getEimJson(true);
                    IDE.openEditor((IWorkbenchPage)activeww.getActivePage(), (IEditorInput)new EimEditorInput(eimJson), (String)"com.espressif.idf.ui.manageespidf", (boolean)true);
                }
                catch (EimVersionMismatchException | IOException | PartInitException e) {
                    Logger.log((String)"Failed to open ESP-IDF Manager Editor.");
                    Logger.log((Exception)e);
                    if (!(e instanceof EimVersionMismatchException)) break block3;
                    EimVersionMismatchException eimEx = (EimVersionMismatchException)e;
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)eimEx.msgTitle(), (String)eimEx.getMessage());
                }
            }
        });
    }

    static /* synthetic */ void access$0(EimButtonLaunchListener eimButtonLaunchListener) {
        eimButtonLaunchListener.refreshAfterEimClose();
    }

    private class EimDownlaodListener
    implements DownloadListener {
        private EimDownlaodListener() {
        }

        public void onProgress(int percent) {
            EimButtonLaunchListener.this.display.asyncExec(() -> {
                try {
                    int blocks = percent / 10;
                    String bar = "[" + "#".repeat(blocks) + " ".repeat(10 - blocks) + "] " + percent + "%";
                    EimButtonLaunchListener.this.standardConsoleStream.write("\r" + bar);
                }
                catch (IOException e) {
                    Logger.log((Exception)e);
                }
            });
        }

        public void onCompleted(String filePath) {
            EimButtonLaunchListener.this.display.syncExec(() -> {
                try {
                    EimButtonLaunchListener.this.standardConsoleStream.write("\nEIM Downloaded to: " + filePath + "\nLaunching...\n");
                }
                catch (IOException e) {
                    Logger.log((Exception)e);
                }
            });
            String appToLaunch = filePath;
            if (filePath.endsWith(".dmg")) {
                try {
                    appToLaunch = EimButtonLaunchListener.this.eimLoader.installAndLaunchDmg(Paths.get(filePath, new String[0]));
                }
                catch (IOException | InterruptedException e) {
                    Logger.log((Exception)e);
                }
            }
            try {
                EimButtonLaunchListener.this.idfEnvironmentVariables.addEnvVariable("EIM_PATH", appToLaunch);
                Process process = EimButtonLaunchListener.this.eimLoader.launchEim(appToLaunch);
                EimButtonLaunchListener.this.eimLoader.waitForEimClosure(process, () -> EimButtonLaunchListener.access$0(EimButtonLaunchListener.this));
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }

        public void onError(String message, Exception e) {
            EimButtonLaunchListener.this.display.asyncExec(() -> {
                try {
                    EimButtonLaunchListener.this.errorConsoleStream.write("Download Failed: " + e.getMessage());
                }
                catch (IOException e1) {
                    Logger.log((Exception)e1);
                }
            });
        }
    }
}

