/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.templates;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.templates.TemplateNode;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TemplatesReader {
    public TemplateNode getTemplates() {
        TemplateNode root = new TemplateNode(null, null, null, 8);
        String idf_path = new IDFEnvironmentVariables().getEnvValue("IDF_PATH");
        Logger.log((String)("IDF path " + idf_path));
        File idfpath_file = new File(idf_path + "/examples");
        if (idfpath_file.isDirectory()) {
            this.buildTemplatesRecursively(idfpath_file, root);
            return root;
        }
        return root;
    }

    private void buildTemplatesRecursively(File idfpath_file, TemplateNode root) {
        File[] listFiles;
        File[] fileArray = listFiles = idfpath_file.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.isCMakeFileExists(file)) {
                root.add(new TemplateNode(file.getName(), file, root, 4));
            } else if (file.isDirectory() && file.getName().equals("get-started")) {
                this.addBasicTemplatesAtRoot(root, file);
            } else if (file.isDirectory()) {
                TemplateNode folderNode = new TemplateNode(file.getName(), file, root, 2);
                root.add(folderNode);
                this.buildTemplatesRecursively(file, folderNode);
            }
            ++n2;
        }
    }

    private void addBasicTemplatesAtRoot(TemplateNode root, File file) {
        File[] basicTemplatesProjects = file.listFiles();
        if (basicTemplatesProjects == null) {
            return;
        }
        File[] fileArray = basicTemplatesProjects;
        int n = basicTemplatesProjects.length;
        int n2 = 0;
        while (n2 < n) {
            File template = fileArray[n2];
            if (this.isCMakeFileExists(template)) {
                root.addFirst(new TemplateNode(template.getName(), template, null, 4));
            }
            ++n2;
        }
    }

    private boolean isCMakeFileExists(File file) {
        IPath cmakeListFile = new Path(file.getAbsolutePath()).append("CMakeLists.txt");
        return cmakeListFile.toFile().exists();
    }
}

