/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.templates;

import com.espressif.idf.ui.templates.ITemplateManager;
import com.espressif.idf.ui.templates.ITemplateNode;
import com.espressif.idf.ui.templates.TemplateNode;
import com.espressif.idf.ui.templates.TemplatesReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;

public class TemplatesManager
implements ITemplateManager {
    private TemplatesReader templateReader = new TemplatesReader();

    @Override
    public ITemplateNode getTemplates() {
        return this.templateReader.getTemplates();
    }

    public String getProjectName(ITemplateNode template) {
        return template.getName();
    }

    @Override
    public String getDescription(ITemplateNode template) throws IOException {
        String readmePath = template.getFilePath().getAbsolutePath() + "/README.md";
        if (new File(readmePath).isFile()) {
            return this.read(readmePath);
        }
        return "";
    }

    protected String read(String filePath) throws IOException {
        String data = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        return data;
    }

    public ITemplateNode getTemplateNode(String templateId) {
        TemplateNode root = this.templateReader.getTemplates();
        List<ITemplateNode> children = root.getChildren();
        for (ITemplateNode iTemplateNode : children) {
            if (iTemplateNode.getType() != 4 || !iTemplateNode.getName().equals(templateId)) continue;
            return iTemplateNode;
        }
        return null;
    }
}

