/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.templates;

import com.espressif.idf.ui.templates.BaseWizardSelectionPage;
import com.espressif.idf.ui.templates.ITemplateNode;
import com.espressif.idf.ui.templates.Messages;
import com.espressif.idf.ui.templates.TemplateListPatternFilter;
import com.espressif.idf.ui.templates.TemplatesContentProvider;
import com.espressif.idf.ui.templates.TemplatesLabelProvider;
import com.espressif.idf.ui.templates.TemplatesManager;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class AbstractTemplatesSelectionPage
extends BaseWizardSelectionPage
implements IExecutableExtension {
    protected TreeViewer templateViewer;
    protected ITemplateNode templateElements;
    protected FilteredTree filteredTree;
    private WizardSelectedAction doubleClickAction = new WizardSelectedAction();
    private Group templateGroup;
    private Button fUseTemplate;

    public AbstractTemplatesSelectionPage(ITemplateNode wizardElements, String message) {
        super("ListSelection", message);
        this.templateElements = wizardElements;
    }

    public void advanceToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public ITemplateNode getWizardElements() {
        return this.templateElements;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createAbove(container, 1);
        if (this.templateElements == null || this.templateElements.getChildren().isEmpty()) {
            Dialog.applyDialogFont((Control)container);
            this.setControl((Control)container);
            return;
        }
        GridData gd = new GridData();
        this.templateGroup = new Group(container, 0);
        this.fUseTemplate = new Button((Composite)this.templateGroup, 32);
        SashForm sashForm = new SashForm((Composite)this.templateGroup, 256);
        gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 350;
        sashForm.setLayoutData((Object)gd);
        this.templateGroup.setText(Messages.TemplateGroupHeader);
        GridLayout groupLayout = new GridLayout();
        this.templateGroup.setLayout((Layout)groupLayout);
        GridData gridDataGp = new GridData(1808);
        gridDataGp.widthHint = 400;
        gridDataGp.heightHint = 350;
        this.templateGroup.setLayoutData((Object)gridDataGp);
        this.fUseTemplate.setText(Messages.TemplateListSelectionPage_SelectTemplate_Desc);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.fUseTemplate.setLayoutData((Object)gridData);
        this.fUseTemplate.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.templateViewer.getControl().setEnabled(this.fUseTemplate.getSelection());
            this.filteredTree.setEnabled(this.fUseTemplate.getSelection());
            if (!this.fUseTemplate.getSelection()) {
                this.setDescription("");
            } else {
                this.setDescription(Messages.TemplateListSelectionPage_Template_Wizard_Desc);
            }
            this.setDescriptionEnabled(this.fUseTemplate.getSelection());
            this.getContainer().updateButtons();
        }));
        this.fUseTemplate.setSelection(false);
        this.templateViewer = this.createTreeViewer((Composite)sashForm);
        this.templateViewer.setContentProvider((IContentProvider)new TemplatesContentProvider());
        this.templateViewer.setLabelProvider((IBaseLabelProvider)new TemplatesLabelProvider());
        this.templateViewer.setComparator(this.getViewerComparator());
        this.templateViewer.addDoubleClickListener(event -> this.doubleClickAction.run());
        this.createDescriptionIn((Composite)sashForm);
        this.createBelow(container, 1);
        if (this.templateElements != null && !this.templateElements.getChildren().isEmpty()) {
            this.templateViewer.setInput((Object)this.templateElements);
        }
        this.initializeViewer();
        this.templateViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private TreeViewer createTreeViewer(Composite templatesGroup) {
        TemplateListPatternFilter filter = new TemplateListPatternFilter();
        int style = 2820;
        this.filteredTree = new FilteredTree(templatesGroup, style, (PatternFilter)filter, true, true);
        this.filteredTree.setEnabled(false);
        this.filteredTree.getParent().setToolTipText(Messages.TemplateSelectionToolTip);
        TreeViewer treeViewer = this.filteredTree.getViewer();
        treeViewer.setContentProvider((IContentProvider)new TemplatesContentProvider());
        TemplatesLabelProvider labelProvider = new TemplatesLabelProvider();
        treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        treeViewer.setComparator(this.getViewerComparator());
        treeViewer.setUseHashlookup(true);
        return treeViewer;
    }

    private ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            public int compare(Viewer testViewer, Object e1, Object e2) {
                int message1 = ((ITemplateNode)e1).getType();
                int message2 = ((ITemplateNode)e2).getType();
                return message2 - message1;
            }
        };
    }

    protected void createAbove(Composite container, int span) {
    }

    protected void createBelow(Composite container, int span) {
    }

    protected void initializeViewer() {
    }

    protected boolean validatePage() {
        return true;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(null);
        IStructuredSelection selection = event.getStructuredSelection();
        ITemplateNode currentWizardSelection = null;
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            currentWizardSelection = (ITemplateNode)iter.next();
        }
        if (currentWizardSelection == null) {
            this.setDescriptionText("");
            this.setSelectedNode(null);
            return;
        }
        ITemplateNode finalSelection = currentWizardSelection;
        String description = "";
        try {
            description = new TemplatesManager().getDescription(finalSelection);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setDescriptionText(description);
        this.getContainer().updateButtons();
    }

    public IWizardPage getNextPage(boolean shouldCreate) {
        if (!shouldCreate) {
            return super.getNextPage();
        }
        IWizardNode selectedNode = this.getSelectedNode();
        selectedNode.dispose();
        IWizard wizard = selectedNode.getWizard();
        if (wizard == null) {
            super.setSelectedNode(null);
            return null;
        }
        if (shouldCreate) {
            wizard.addPages();
        }
        return wizard.getStartingPage();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public boolean canFlipToNextPage() {
        ITreeSelection ssel = this.templateViewer.getStructuredSelection();
        return ssel != null && !ssel.isEmpty();
    }

    public Button getfUseTemplate() {
        return this.fUseTemplate;
    }

    public void setfUseTemplate(Button fUseTemplate) {
        this.fUseTemplate = fUseTemplate;
    }

    private class WizardSelectedAction
    extends Action {
        public WizardSelectedAction() {
            super("wizardSelection");
        }

        public void run() {
            AbstractTemplatesSelectionPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)AbstractTemplatesSelectionPage.this.templateViewer, (ISelection)AbstractTemplatesSelectionPage.this.templateViewer.getStructuredSelection()));
            AbstractTemplatesSelectionPage.this.advanceToNextPage();
        }
    }
}

