/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.size;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.size.IDFSizeComparator;
import com.espressif.idf.ui.size.IDFSizeDataContentProvider;
import com.espressif.idf.ui.size.IDFSizeDataLabelProvider;
import com.espressif.idf.ui.size.IDFSizeDataManager;
import com.espressif.idf.ui.size.IDFSizePatternFilter;
import com.espressif.idf.ui.size.vo.LibraryMemoryComponent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class IDFSizeDetailsComposite {
    private TreeViewer treeViewer;
    private LinkedHashSet<String> allColumns = new LinkedHashSet();
    private LinkedHashSet<String> visibleColumns = new LinkedHashSet();
    private IFile currentFile;
    private Composite treeContainer;

    public void createPartControl(Composite parent, IFile iFile) {
        this.currentFile = iFile;
        if (this.treeContainer != null && !this.treeContainer.isDisposed()) {
            this.treeContainer.dispose();
        }
        this.treeContainer = new Composite(parent, 0);
        this.treeContainer.setLayout((Layout)new GridLayout(1, false));
        this.treeContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Button columnSelectBtn = new Button(this.treeContainer, 8);
        columnSelectBtn.setText("Select Columns...");
        columnSelectBtn.setLayoutData((Object)new GridData(16384, 128, true, false));
        columnSelectBtn.addListener(13, e -> this.openColumnSelectionDialog());
        List<Object> dataList = new ArrayList();
        try {
            dataList = new IDFSizeDataManager().getDataList(this.currentFile);
        }
        catch (Exception e2) {
            Logger.log((Exception)e2);
        }
        LinkedHashSet<Object> columnList = new LinkedHashSet<Object>();
        columnList.add("File Name");
        for (LibraryMemoryComponent libraryMemoryComponent : dataList) {
            for (String memoryType : libraryMemoryComponent.getMemoryTypes().keySet()) {
                for (String memorySection : libraryMemoryComponent.getMemoryTypes().get(memoryType).getSections().keySet()) {
                    columnList.add(memoryType + " -> " + memorySection);
                }
                columnList.add(memoryType + " Total");
            }
        }
        columnList.add("Total");
        if (this.allColumns.isEmpty()) {
            this.allColumns.addAll(columnList);
            this.visibleColumns.addAll(columnList);
        }
        IDFSizePatternFilter iDFSizePatternFilter = new IDFSizePatternFilter();
        FilteredTree filteredTree = new FilteredTree(this.treeContainer, 67588, (PatternFilter)iDFSizePatternFilter, true, true);
        GridData gridData = new GridData(4, 4, true, true);
        filteredTree.setLayoutData((Object)gridData);
        this.treeViewer = filteredTree.getViewer();
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        IDFSizeComparator comparator = new IDFSizeComparator();
        int i = 0;
        for (String column : this.visibleColumns) {
            TreeColumn tc = new TreeColumn(tree, 0, i);
            tc.setText(column);
            tc.addSelectionListener((SelectionListener)new ResortColumn(comparator, tc, this.treeViewer, i++));
            tc.pack();
        }
        if (tree.getColumnCount() > 0) {
            tree.setSortColumn(tree.getColumn(0));
            tree.setSortDirection(128);
        }
        this.treeViewer.setContentProvider((IContentProvider)new IDFSizeDataContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new IDFSizeDataLabelProvider(this.visibleColumns));
        this.treeViewer.setInput(dataList);
        this.treeViewer.setComparator((ViewerComparator)comparator);
        this.treeContainer.layout(true, true);
        parent.layout(true, true);
    }

    private void openColumnSelectionDialog() {
        Shell shell = new Shell(this.treeContainer.getShell(), 67680);
        shell.setText("Choose Columns");
        shell.setLayout((Layout)new GridLayout(1, false));
        ArrayList<Button> checkboxes = new ArrayList<Button>();
        for (String col : this.allColumns) {
            Button checkbox = new Button((Composite)shell, 32);
            checkbox.setText(col);
            checkbox.setSelection(this.visibleColumns.contains(col));
            checkboxes.add(checkbox);
        }
        Button applyBtn = new Button((Composite)shell, 8);
        applyBtn.setText("Apply");
        applyBtn.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        applyBtn.addListener(13, e -> {
            this.visibleColumns.clear();
            for (Button cb : checkboxes) {
                if (!cb.getSelection()) continue;
                this.visibleColumns.add(cb.getText());
            }
            shell.close();
            this.rebuildTree();
        });
        shell.pack();
        shell.open();
    }

    private void rebuildTree() {
        if (this.treeContainer != null && !this.treeContainer.isDisposed()) {
            Composite parent = this.treeContainer.getParent();
            this.treeContainer.dispose();
            this.createPartControl(parent, this.currentFile);
            parent.layout(true, true);
        }
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    private final class ResortColumn
    extends SelectionAdapter {
        private final IDFSizeComparator comparator;
        private final TreeColumn treeColumn;
        private final TreeViewer viewer;
        private final int column;

        private ResortColumn(IDFSizeComparator comparator, TreeColumn treeColumn, TreeViewer viewer, int column) {
            this.comparator = comparator;
            this.treeColumn = treeColumn;
            this.viewer = viewer;
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.comparator.getSortColumn() == this.column) {
                this.comparator.setAscending(!this.comparator.isAscending());
                this.viewer.getTree().setSortDirection(this.comparator.isAscending() ? 128 : 1024);
            } else {
                this.viewer.getTree().setSortColumn(this.treeColumn);
                this.comparator.setSortColumn(this.column);
            }
            try {
                this.viewer.refresh();
            }
            finally {
                this.viewer.getTree().setRedraw(true);
            }
        }
    }
}

